% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{getNumReadsR_vector}
\alias{getNumReadsR_vector}
\title{Compute the number of reference reads}
\usage{
getNumReadsR_vector(genotype_v, readCount_v, error)
}
\arguments{
\item{genotype_v}{is a vector with the genotype of a given individual. Each
entry of the vector should be a different site. Genotypes should be encoded
as 0: reference homozygote, 1: heterozygote and 2: alternative homozygote.}

\item{readCount_v}{is a vector with the number of reads contributed by the
same given individual. Each entry of that vector should be a different
site.}

\item{error}{a numeric value with error rate associated with the sequencing
and mapping process. This error rate is assumed to be symmetric:
error(reference -> alternative) = error(alternative -> reference). This
number should be between 0 and 1.}
}
\value{
a vector with the number of reference allele reads. Each entry of the
vector corresponds to a different individual.
}
\description{
This function takes as input the total depth of coverage and computes how
many of those reads are reference allele reads.
}
\details{
More precisely, this function computes the number of reference reads per site
for one individual, given the genotype of the individual at each site, the
total number of reads observed for the individual at that site and an error
rate.
}
\examples{
# number of reference allele reads for three individuals, each with 10x coverage
# one individual is homozygote for the reference allele (0), other is heterozygote (1)
# and the last is homozygote for the alternative allele (2)
getNumReadsR_vector(genotype_v = c(0,1,2), readCount_v = c(10, 10, 10), error = 0.01)

}
