% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_setup.R
\name{GeneIdentityMatrix}
\alias{GeneIdentityMatrix}
\title{Gene Identity Matrix}
\usage{
GeneIdentityMatrix(RawData = data.frame, LociGenotyped = matrix)
}
\arguments{
\item{RawData}{A data frame containing the input data must be in LoadData
style \link{LoadData}.}

\item{LociGenotyped}{The Output from the TypedLoci function}
}
\value{
The Gene Identity Matrix
}
\description{
Using the number of typed loci, this function calculates the gene identity
between all possible pairwise combinations between individuals for all
markers creating a matrix.
}
\examples{
genetic_data <- data.frame(
Locus = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
Locus_allele = c("Marker1", "n", 1, 2, 3, "Marker2", "n", 1, 2, 3),
Sample1 = c(NA, 10, 0.5, 0.5, 0, NA, 10, 0.2, 0.3, 0.5),
Sample2 = c(NA, 20, 0.1, 0.2, 0.7, NA, 20, 0.3, 0.4, 0.3),
Sample3 = c(NA, 30, 0.3, 0.4, 0.3, NA, 30, 0.4, 0.2, 0.4)
)

n_alleles <- matrix(c(
3, 3, 3,
3, 3, 3,
3, 3, 3
), nrow = 3, byrow = TRUE,
dimnames = list(paste0("Sample", 1:3), paste0("Sample", 1:3)))

GeneIdentityMatrix(RawData=genetic_data,LociGenotyped=n_alleles)
}
