% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_admix.R
\name{plot_admix}
\alias{plot_admix}
\title{Make a structure/admixture plot}
\usage{
plot_admix(
  Q,
  col = RColorBrewer::brewer.pal(max(ncol(Q), 3), "Paired"),
  mar_pad = 0.2,
  panel_letters = NA,
  panel_letters_cex = 1.5,
  panel_letters_adj = -0.1,
  axis_lab_cex = 1,
  xlab = "Individuals",
  xlab_line = 1,
  xlab_cex = axis_lab_cex,
  ylab = "Ancestry",
  ylab_line = 2,
  ylab_side = 2,
  ylab_cex = axis_lab_cex,
  leg_title = "Ancestries",
  leg_title_cex = axis_lab_cex,
  leg_title_line = 2,
  leg_cex = 1,
  leg_mar = leg_title_line + 1,
  leg_width = 0.2,
  leg_las = 0,
  leg_omit = FALSE,
  layout_add = !leg_omit,
  names = FALSE,
  names_cex = 1,
  names_line = NA,
  names_las = 2,
  labs = NULL,
  labs_cex = 1,
  labs_las = 0,
  labs_line = 0,
  labs_sep = TRUE,
  labs_lwd = 1,
  labs_col = "black",
  labs_ticks = FALSE,
  labs_text = TRUE,
  labs_even = FALSE,
  ...
)
}
\arguments{
\item{Q}{The admixture proportions matrix, with \code{n} individuals along rows and \code{K} ancestries along columns.
Rows should sum to 1, but this is not enforced.
There must be at least 2 ancestries.
The ancestry labels used by the legend must be the column names, which are unlabeled if the column names are missing.}

\item{col}{A vector of at least \code{K} colors for the ancestries (extra colors are ignored).
By default uses the "Paired" palette of \code{RColorBrewer}, which has at most 12 colors, so please provide colors if \code{K > 12}.
Since the minimum number of colors for "Paired" is 3, when \code{K = 2} we ask for 3 colors, then remove the middle color internally.}

\item{mar_pad}{Margin padding used for legend panel only (margins for first/main panel are not altered by this function).}

\item{panel_letters}{Panel letter to include in first/main panel (default \code{NA} is no letter).
Despite name (matches \code{\link[=plot_popkin]{plot_popkin()}}), must be scalar.}

\item{panel_letters_cex}{Scaling factor of panel letter (default 1.5).}

\item{panel_letters_adj}{X-axis adjustment for panel letter (default -0.1).
Negative values place the letter into the left margin area.
Might need adjustment depending on the size of the left margin.

AXIS LABEL OPTIONS}

\item{axis_lab_cex}{Scaling factor for x-axis, y-axis, and legend title labels (which can also be set individually, see below).}

\item{xlab}{X-axis label (default "Individuals").
Set to \code{NA} to omit.}

\item{xlab_line}{The value of \code{line} for \code{xlab} passed to \code{\link[graphics:mtext]{graphics::mtext()}}.}

\item{xlab_cex}{Scaling factor for x-axis label.}

\item{ylab}{Y-axis label (default "Ancestry").
Set to \code{NA} to omit.}

\item{ylab_line}{The value of \code{line} for \code{ylab} passed to \code{\link[graphics:mtext]{graphics::mtext()}}.}

\item{ylab_side}{The value of \code{side} for \code{ylab} passed to \code{\link[graphics:mtext]{graphics::mtext()}} (2 is y-axis, 1 is x-axis, can also place on top (3) or right (4)).}

\item{ylab_cex}{Scaling factor for y-axis label.

LEGEND (COLOR KEY) OPTIONS}

\item{leg_title}{The name of the categorical ancestry variable (default "Ancestries").}

\item{leg_title_cex}{Scaling factor for legend title label.}

\item{leg_title_line}{The value of \code{line} for \code{leg_title} passed to \code{\link[graphics:mtext]{graphics::mtext()}}.}

\item{leg_cex}{Scaling factor for ancestry labels.}

\item{leg_mar}{Margin values for the kinship legend panel only.
A length-4 vector (in \code{c( bottom, left, top, right )} format that \code{\link[graphics:par]{graphics::par()}} 'mar' expects) specifies the full margins, to which \code{mar_pad} is added.
Otherwise, the margins used in the last panel are preserved with the exception that the left margin is set to \code{mar_pad}, and if \code{leg_mar} is length-1 (default), it is added to \code{mar_pad} to specify the right margin.
By default the right margin is large enough to accommodate \code{leg_title} for the given value of \code{leg_title_line}.}

\item{leg_width}{The width of the legend panel, relative to the width of the main panel.
This value is passed to \code{\link[graphics:layout]{graphics::layout()}} (ignored if \code{layout_add = FALSE}).}

\item{leg_las}{The ancestry label orientations (in format that \code{\link[graphics:mtext]{graphics::mtext()}} expects).}

\item{leg_omit}{If \code{TRUE}, no legend (second panel) is produced (default \code{FALSE} is to include legend).}

\item{layout_add}{If \code{TRUE} (default) then \code{\link[graphics:layout]{graphics::layout()}} is called internally to create two panels: the main panel and the color key legend.
The original layout is reset when plotting is complete and if \code{layout_add = TRUE}.
If a non-standard layout or additional panels (beyond those provided by this function) are desired, set to \code{FALSE} and call \code{\link[graphics:layout]{graphics::layout()}} yourself beforehand.

INDIVIDUAL LABEL OPTIONS}

\item{names}{If \code{TRUE}, the row (individual) names are plotted in the structure barplot.}

\item{names_cex}{Scaling factor for the individual names.}

\item{names_line}{Line where individual names are placed.}

\item{names_las}{Orientation of labels relative to axis.
Default (2) makes labels perpendicular to axis.

SUBPOPULATION LABEL OPTIONS}

\item{labs}{Subpopulation labels for individuals in the admixture matrix.
Use a matrix of labels to show groupings at more than one level (for a hierarchy or otherwise).}

\item{labs_cex}{A vector of label scaling factors for each level of labs.}

\item{labs_las}{A vector of label orientations (in format that \code{\link[graphics:mtext]{graphics::mtext()}} expects) for each level of labs.}

\item{labs_line}{A vector of lines where labels are placed (in format that \code{\link[graphics:mtext]{graphics::mtext()}} expects) for each level of labs.}

\item{labs_sep}{A vector of logicals that specify whether lines separating the subpopulations are drawn for each level of labs.}

\item{labs_lwd}{A vector of line widths for the lines that divide subpopulations (if \code{labs_sep = TRUE}) for each level of labs.}

\item{labs_col}{A vector of colors for the lines that divide subpopulations (if \code{labs_sep = TRUE}) for each level of labs.}

\item{labs_ticks}{A vector of logicals that specify whether ticks separating the subpopulations are drawn for each level of labs.}

\item{labs_text}{A vector of logicals that specify whether the subpopulation labels are shown for each level of labs.
Useful for including separating lines or ticks without text.}

\item{labs_even}{A vector of logicals that specify whether the subpopulations labels are drawn with equal spacing for each level of labs.
When \code{TRUE}, lines mapping the equally-spaced labels to the unequally-spaced subsections of the heatmap are also drawn.}

\item{...}{Additional options passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}
}
\description{
This function facilitates structure plots with options that resemble those of \code{\link[=plot_popkin]{plot_popkin()}} in name and results.
The biggest difference is this function plots single panels (technically 2 panels including the legend, unless it is omitted), whereas \code{\link[=plot_popkin]{plot_popkin()}} can plot multiple kinship matrices with a shared legend.
}
\examples{
# create random proportions for two ancestries
Q <- runif( 10 )
Q <- cbind( Q, 1 - Q )
# add ancestry names
colnames( Q ) <- c('A1', 'A2')

# plot this data!
plot_admix( Q )

# See vignette for more elaborate examples!

}
\seealso{
\code{\link[=admix_order_cols]{admix_order_cols()}} to automatically order ancestries given ordered individuals.

\code{\link[=admix_label_cols]{admix_label_cols()}} to automatically assign labels to ancestries given labels to individuals.
}
