% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticmpt.R
\name{staticmpt}
\alias{staticmpt}
\title{Static Portfolio Optimization}
\usage{
staticmpt(mus, rbar, vmat)
}
\arguments{
\item{mus}{An array of the expected values}

\item{rbar}{An array of the observed mean returns}

\item{vmat}{A variance and covariance matrix}
}
\value{
A list including the following component: \cr
\cr
\code{rbar} An array of the observed mean returns \cr
\cr
\code{vmat} A variance and covariance matrix \cr
\cr
\code{efdata} A data.frame including: \cr
- \code{sd} standard deviation \cr
- \code{er} expected return in mus \cr
- \code{conv} convergence status in optimization (0 = successful, otherwise: not an interior solution) \cr
- \code{w1, w2, ...} portfolio weights \cr
- \code{ef} 1 = on the efficient frontier and 0 = not on the efficient frontier \cr
}
\description{
The function generates portfolio weights for nature or conservation
}
\details{
This function solves the series of the standard Markowitz portfolio analysis for nature or conservation, i.e., the quadratic problem without shorting.\cr
\cr
min w' vmat w \cr
s.t. w rbar = mu \cr
w' 1 = 1 where w >= 0 \cr
\cr
where \code{w} is an array of non-negative portfolio weights, \code{rbar} is an array of the observed mean returns, \code{vmat} a matrix of variance-covariance matrix, and \code{mu} is an expected value.
}
\examples{
## No change likely scenario of CCI in Figure 2, Ando and Mallory (2012)
rs <- c(0.265,0.671,0.372)
vmat <- matrix(c(0.003,0.005,-0.006,0.005,0.013,-0.010,-0.006,-0.010,0.012),ncol=3)
mus <- seq(min(rs),max(rs),length.out=100)
cci <- staticmpt(mus,rs,vmat)
}
\references{
Ando, A. W. and M. L. Mallory. (2012) "Optimal Portfolio Design to Reduce Climate-related Conservation Uncertainty in the Prairie Pothole Region." Proceedings of the National Academy of Sciences (PNAS). 109 (17) pp. 6484-6489.
}
\seealso{
\code{\link{plotef}}
}
