% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/po_update.R
\name{po_update}
\alias{po_update}
\title{Update all \code{.po} files with changes in \code{.pot}}
\usage{
po_update(dir = ".", lazy = TRUE, verbose = !is_testing())
}
\arguments{
\item{dir}{Character, default the present directory; a directory in which an
R package is stored.}

\item{lazy}{If \code{TRUE}, only \code{.po} files that are older than their
corresponding \code{.pot} file will be updated.}

\item{verbose}{Logical, default \code{TRUE} (except during testing). Should
extra information about progress, etc. be reported?}
}
\description{
\code{po_update()} updates existing \code{.po} file after the \code{.pot} file has changed.
There are four cases:
\itemize{
\item New messages: added with blank \code{msgstr}.
\item Deleted messages: marked as deprecated and moved to the bottom of the file.
\item Major changes to existing messages: appear as an addition and a deletion.
\item Minor changes to existing messages: will be flagged as fuzzy.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#, fuzzy, c-format
#| msgid "Generating en@quot translations"
msgid "Updating '\%s' \%s translation"
msgstr "memperbarui terjemahan bahasa en@quot..."
}\if{html}{\out{</div>}}

The previous message is given in comments starting with \verb{#|}.
Translators need to update the actual (uncommented) \code{msgstr} manually,
using the old \code{msgid} as a potential reference, then
delete the old translation and the \code{fuzzy} comment (c-format should
remain, if present).
}
}
