% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgumbel.R, R/pgumbel.R, R/qgumbel.R,
%   R/rgumbel.R
\name{Gumbel}
\alias{Gumbel}
\alias{dgumbel}
\alias{Gumbel}
\alias{pgumbel}
\alias{Gumbel}
\alias{qgumbel}
\alias{Gumbel}
\alias{rgumbel}
\title{The Gumbel Distribution}
\usage{
dgumbel(x, mu = 0, sigma = 1, log = FALSE)

pgumbel(q, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qgumbel(p, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rgumbel(n, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the Gumbel distribution with parameters mu and sigma.
}
\details{
The Gumbel distribution has density

\eqn{f(x)=\left[\frac{1}{\sigma}e^{\left(-\frac{x-\mu}{\sigma}\right)-e^{\left(-\frac{x-\mu}{\sigma}\right)}}\right]}{f(x)=(1/\sigma)exp(-(x-\mu)/\sigma-exp(-(x-\mu)/\sigma))},

where \eqn{-\infty<\mu<\infty} is the location paramether and \eqn{\sigma^2>0} is the scale parameter.
}
\examples{
dgumbel(1, 3, 4)
pgumbel(1, 3, 4)
qgumbel(0.2, 3, 4)
rgumbel(5, 3, 4)
}
