% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{fitted.ppgam}
\alias{fitted.ppgam}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{ppgam}(object, ...)
}
\arguments{
\item{object}{a fitted \code{ppgam} object}

\item{...}{not used}
}
\value{
Fitted values extracted from the object `object'.
}
\description{
Extract Model Fitted Values
}
\examples{

# Times of landfalling US hurricanes
data(USlandfall)

# convert dates to years, as a continuous variable
year <- as.integer(format(USlandfall$date, "\%Y"))
day <- as.integer(format(USlandfall$date, "\%j"))
USlandfall$year <- year + pmin(day / 365, 1)
hits <- subset(USlandfall, landfall == 1)

m1 <- ppgam( ~ s(year), hits)
fitted(m1)

}
