% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTable1.R
\name{createTable1}
\alias{createTable1}
\title{Creation of an overall "Table 1" of baseline patient characteristics before and after weighting}
\usage{
createTable1(XsummaryList, digits = 2)
}
\arguments{
\item{XsummaryList}{A list of summary-level information tables shared by data-contributing sites. Each site provides one table, which can be obtained by using the function \code{\link[ppmHR]{computeInfoForTable1}} in this package.}

\item{digits}{An integer indicating the number of decimal places for the generated "Table 1". The default is 2.}
}
\value{
A data frame of the "Table 1". Each row represents a covariate. The seven columns represent the covariate type ("yes" if it is binary, "no" if it is continuous or count), the exposed group in the original sample, the unexposed group in the original sample, the exposed group in the weighted sample with conventional weights, the unexposed group in the weighted sample with conventional weights, the exposed group in the weighted sample with stabilized weights, and the unexposed group in the weighted sample with stabilized weights. For cells of binary covariates, values are count(percentage). For cells of continuous or count covariates, values are mean(standard deviation).
}
\description{
Creation of an overall "Table 1" of baseline patient characteristics in the original unweighted and the inverse probability weighted samples, using only summary-level information shared by data-contributing sites. This is a function for the analysis center.
}
\examples{
#load example datasets in the package
#site1-3 contain individual-level data of data-contributing sites 1-3
data(site1)
data(site2)
data(site3)
#sites 1-3 compute summary-level information needed for creating the "Table 1"
#with logistic propensity score model A~X1+X2+X3+X4+X5
#no weight truncation
Xsummary1=computeInfoForTable1(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=1)
Xsummary2=computeInfoForTable1(data=site2,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=1)
Xsummary3=computeInfoForTable1(data=site3,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=1)
#analysis center creates the "Table 1"
#using summary-level information Xsummary1-3 shared by data-contributing sites
#display the table with 3 decimal places
createTable1(list(Xsummary1,Xsummary2,Xsummary3),digits=3)
#analysis center can also generate site-specific "Table 1"
#for example, for site 1
createTable1(list(Xsummary1),digits=3)

}
