% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossv.R
\name{abc.precmed}
\alias{abc.precmed}
\title{Compute the area between curves from the \code{"precmed"} object}
\usage{
\method{abc}{precmed}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"precmed"}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Returns a matrix of numeric values with number of columns equal to the number cross-validation
iteration and number of rows equal to the number of scoring methods in \code{x}.
}
\description{
Compute the area between curves (ABC) for each scoring method in the \code{"precmed"} object.
This should be run only after results of \code{\link{catecv}()} have been obtained.
}
\details{
The ABC is the area between a validation curve and the overall ATE in the validation set.
It is calculated for each scoring method separately. Higher ABC values are preferable as they
indicate that more treatment effect heterogeneity is captured by the scoring method.
Negative values of ABC are possible if segments of the validation curve cross the overall ATE line.
The ABC is calculated with the \code{\link{auc}()} in \code{utility.R} with a natural
cubic spline interpolation. The calculation of the ABC is always based on validation curves based on
100 proportions equally spaced from \code{min(prop.cutoff)} to \code{max(prop.cutoff)}.

The ABC is a metric to help users select the best scoring method in terms of capturing treatment
effect heterogeneity in the data. It should be used in complement to the visual inspection of
the validation curves in the validation set in \code{\link{plot}()}.
}
\examples{
\donttest{
# Count outcome
cv_count <- catecv(response = "count",
                   data = countExample,
                   score.method = "poisson",
                   cate.model = y ~ age + female + previous_treatment +
                                previous_cost + previous_number_relapses +
                                offset(log(years)),
                   ps.model = trt ~ age + previous_treatment,
                   higher.y = FALSE, cv.n = 5, verbose = 1)

# ABC of the validation curves for each method and each CV iteration
abc(cv_count)

# Survival outcome
library(survival)
cv_surv <- catecv(response = "survival",
                  data = survivalExample,
                  score.method = c("poisson", "randomForest"),
                  cate.model = Surv(y, d) ~ age + female + previous_cost +
                               previous_number_relapses,
                  ps.model = trt ~ age + previous_treatment,
                  higher.y = FALSE,
                  cv.n = 5)

# ABC of the validation curves for each method and each CV iteration
abc(cv_surv)

}

}
\references{
Zhao, L., Tian, L., Cai, T., Claggett, B., & Wei, L. J. (2013).
\emph{Effectively selecting a target population for a future comparative study.
Journal of the American Statistical Association, 108(502), 527-539.}
}
\seealso{
\code{\link{catecv}()} function and \code{\link{plot}()}, \code{\link{boxplot}()} methods for
\code{"precmed"} objects.
}
