% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{arg.checks.common}
\alias{arg.checks.common}
\title{Check arguments that are common to all types of outcome
USed inside \code{arg.checks()}}
\usage{
arg.checks.common(
  fun,
  ps.method,
  minPS,
  maxPS,
  higher.y = NULL,
  abc = NULL,
  prop.cutoff = NULL,
  prop.multi = NULL,
  B = NULL,
  Kfold = NULL,
  plot.gbmperf = NULL,
  tree.depth = NULL,
  n.trees.boosting = NULL,
  error.maxNR = NULL,
  max.iterNR = NULL,
  tune = NULL,
  train.prop = NULL,
  cv.n = NULL,
  error.max = NULL,
  max.iter = NULL,
  n.boot = NULL,
  plot.boot = NULL
)
}
\arguments{
\item{fun}{A function for which argument check is needed; "pm" for \code{pmcount()}, "cv" for \code{cvcount()},
and "drinf" for \code{drcount.inference()}. No default.}

\item{ps.method}{A character value for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in `[0, 1]`) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in `(0, 1]`) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{higher.y}{A logical value indicating whether higher (\code{TRUE}) or lower (\code{FALSE})
values of the outcome are more desirable. Default is \code{TRUE}.}

\item{abc}{A logical value indicating whether the area between curves (ABC) should be calculated
at each cross-validation iterations, for each \code{score.method}. Default is \code{TRUE}.}

\item{prop.cutoff}{A vector of numerical values (in `(0, 1]`) specifying percentiles of the
estimated log CATE scores to define nested subgroups. Each element represents the cutoff to
separate observations in nested subgroups (below vs above cutoff).
The length of \code{prop.cutoff} is the number of nested subgroups.
An equally-spaced sequence of proportions ending with 1 is recommended.
Default is \code{seq(0.5, 1, length = 6)}.}

\item{prop.multi}{A vector of numerical values (in `[0, 1]`) specifying percentiles of the
estimated log CATE scores to define mutually exclusive subgroups.
It should start with 0, end with 1, and be of \code{length(prop.multi) > 2}.
Each element represents the cutoff to separate the observations into
\code{length(prop.multi) - 1} mutually exclusive subgroups.
Default is \code{c(0, 1/3, 2/3, 1)}.}

\item{B}{A positive integer specifying the number of time cross-fitting is repeated in
\code{score.method = 'twoReg'} and \code{'contrastReg'}. Default is \code{3}.}

\item{Kfold}{A positive integer specifying the number of folds (parts) used in cross-fitting
to partition the data in \code{score.method = 'twoReg'} and \code{'contrastReg'}.
Default is \code{6}.}

\item{plot.gbmperf}{A logical value indicating whether to plot the performance measures in
boosting. Used only if \code{score.method = 'boosting'} or if \code{score.method = 'twoReg'}
or \code{'contrastReg'} and \code{initial.predictor.method = 'boosting'}. Default is \code{TRUE}.}

\item{tree.depth}{A positive integer specifying the depth of individual trees in boosting
(usually 2-3). Used only if \code{score.method = 'boosting'} or
if \code{score.method = 'twoReg'} or \code{'contrastReg'} and
\code{initial.predictor.method = 'boosting'}. Default is \code{2}.}

\item{n.trees.boosting}{A positive integer specifying the maximum number of trees in boosting
(usually 100-1000). Used only if \code{score.method = 'boosting'} or
if \code{score.method = 'twoReg'} or \code{'contrastReg'} and
\code{initial.predictor.method = 'boosting'}. Default is \code{200}.}

\item{error.maxNR}{A numerical value > 0 indicating the minimum value of the mean absolute
error in Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{0.001}.}

\item{max.iterNR}{A positive integer indicating the maximum number of iterations in the
Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{150}.}

\item{tune}{A vector of 2 numerical values > 0 specifying tuning parameters for the
Newton Raphson algorithm. \code{tune[1]} is the step size, \code{tune[2]} specifies a
quantity to be added to diagonal of the slope matrix to prevent singularity.
Used only if \code{score.method = 'contrastReg'}. Default is \code{c(0.5, 2)}.}

\item{train.prop}{A numerical value (in `(0, 1)`) indicating the proportion of total data used
for training. Default is \code{3/4}.}

\item{cv.n}{A positive integer value indicating the number of cross-validation iterations.
Default is \code{10}.}

\item{error.max}{A numerical value > 0 indicating the tolerance (maximum value of error)
for the largest standardized absolute difference in the covariate distributions or in the
doubly robust estimated rate ratios between the training and validation sets. This is used
to define a balanced training-validation splitting. Default is \code{0.1}.}

\item{max.iter}{A positive integer value indicating the maximum number of iterations when
searching for a balanced training-validation split. Default is \code{5,000}.}

\item{n.boot}{A numeric value indicating the number of bootstrap samples used. This is only relevant
if \code{inference = TRUE}. Default is \code{500}.}

\item{plot.boot}{A logic value indicating whether histograms of the bootstrapped log(rate ratio) should
be produced at every \code{n.boot/10}-th iteration and whether the final histogram should be outputted.
Default is \code{FALSE}.}
}
\value{
Nothing. Will stop if arguments are incorrect.
}
\description{
Check arguments that are common to all types of outcome
USed inside \code{arg.checks()}
}
