% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bencalibr.R
\name{bencalibr}
\alias{bencalibr}
\title{Plotting calibration for benefit of a prediction model}
\usage{
bencalibr(
  data = NULL,
  Ngroups = 5,
  y.observed,
  treat,
  predicted.treat.0,
  predicted.treat.1,
  type = "continuous",
  smoothing.function = "lm",
  axis.limits = NULL
)
}
\arguments{
\item{data}{An optional data frame containing the required information.}

\item{Ngroups}{The number of groups to split the data.}

\item{y.observed}{The observed outcome.}

\item{treat}{A vector with the treatment assignment. This must be 0 (for control treatment)
or 1 (for active treatment).}

\item{predicted.treat.0}{A vector with the model predictions for each patient, under the control treatment.
For the case of a binary outcome this should be probabilities of an event.}

\item{predicted.treat.1}{A vector with the model predictions for each patient, under the active treatment.
For the case of a binary outcome this should be probabilities of an event.}

\item{type}{The type of the outcome, "binary" or "continuous".}

\item{smoothing.function}{The method used to smooth the calibration line. Can
be "lm", "glm", "gam", "loess", "rlm". More details can be found in https://ggplot2.tidyverse.org/reference/geom_smooth.html.}

\item{axis.limits}{Sets the limits of the graph. It can be a vector of two values, i.e. the lower and upper limits for x and y axis. It can be omitted.}
}
\value{
The calibration plot
}
\description{
This function produces a plot to illustrate the calibration for benefit
for a prediction model. The samples are split into a number of groups according
to their predicted benefit, and within each group the function estimates
the observed treatment benefit and compares it with the predicted one
}
\examples{
# continuous outcome
dat1=simcont(200)$dat
head(dat1)
lm1=lm(y.observed~(x1+x2+x3)*t, data=dat1)
dat.t0=dat1; dat.t0$t=0
dat.t1=dat1; dat.t1$t=1
dat1$predict.treat.1=predict(lm1, newdata = dat.t1) # predictions in treatment
dat1$predict.treat.0=predict(lm1, newdata = dat.t0) # predicions in control
bencalibr(data=dat1, Ngroups=10, y.observed, predicted.treat.1=predict.treat.1,
          predicted.treat.0=predict.treat.0, type="continuous", treat=t,
          smoothing.function = "lm", axis.limits = c(-1, 1.3))
# binary outcome
dat2=simbinary(500)$dat
head(dat2)
glm1=glm(y.observed~(x1+x2+x3)*t, data=dat2, family = binomial(link = "logit"))
dat2.t0=dat2; dat2.t0$t=0
dat2.t1=dat2; dat2.t1$t=1
dat2$predict.treat.1=predict(glm1, newdata = dat2.t1) # predictions in treatment
dat2$predict.treat.0=predict(glm1, newdata = dat2.t0) # predicions in control
bencalibr(data=dat2, Ngroups=6, y.observed, predicted.treat.1=expit(predict.treat.1),
          predicted.treat.0=expit(predict.treat.0), type="binary", treat=t,
          smoothing.function = "lm")
}
