% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputData.R
\name{inputData}
\alias{inputData}
\alias{inputData,data.frame,data.frame,data.frame,data.frame,data.frame-method}
\title{Creates the multi-action planning problem}
\usage{
inputData(pu, features, dist_features, threats, dist_threats, ...)

\S4method{inputData}{data.frame,data.frame,data.frame,data.frame,data.frame}(
  pu,
  features,
  dist_features,
  threats,
  dist_threats,
  sensitivity = NULL,
  boundary = NULL
)
}
\arguments{
\item{pu}{Object of class \code{\link[=data.frame]{data.frame()}} that specifies the planning units (PU)
of the corresponding instance and their corresponding monitoring cost and status. Each
row corresponds to a different planning unit. This file is inherited from the
\emph{pu.dat} in \emph{Marxan}. It must contain the following columns:
\describe{
\item{\code{id}}{\code{integer} unique identifier for each planning unit.}
\item{\code{monitoring_cost}}{\code{numeric} cost of including each planning unit in the reserve system.}
\item{\code{status}}{\code{integer} (\strong{optional}) value that indicate if each planning unit
should be available to be selected (0), \emph{locked-in} (2) as part of the
solution, or \emph{locked-out} (3) and excluded from the solution.}
}}

\item{features}{Object of class \code{\link[=data.frame]{data.frame()}} that specifies the conservation
features to consider in the optimization problem. Each row corresponds to a different
feature. This file is inherited from marxan's \emph{spec.dat}.

The \code{prioriactions} package supports two types of purposes when optimizing: focus on
recovery of features threatened (through the \strong{recovery target}), where only
take into account benefits when taking action against threats and there is no benefit
when selecting planning units where the features are not threatened;
or include the benefits of the features sites where they are not threatened
(through the \strong{conservation target}).

Note that by default only information on recovery targets is necessary,
while conservation targets equal to zero are assumed. The maximum values of
benefits to achieve both recovery and conservation per feature can be verified
with the \code{getPotentialBenefit()} function.
For more information on the implications of these targets in the solutions see
the \href{https://prioriactions.github.io/prioriactions/articles/objectives.html}{recovery}
vignette.

This file must contain
the following columns:
\describe{
\item{\code{id}}{\code{integer} unique identifier for each conservation feature.}
\item{\code{target_recovery}}{\code{numeric} amount of recovery target to achieve for each conservation feature.
This field is \strong{required} if a \code{minimizeCosts} model is used.}
\item{\code{target_conservation}}{\code{numeric} (\strong{optional}) amount of conservation target to achieve
for each conservation feature.
This field is used only if a model of the type \code{minimizeCosts} is applied.}
\item{\code{name}}{\code{character} (\strong{optional}) name for each conservation feature.}
}}

\item{dist_features}{Object of class \code{\link[=data.frame]{data.frame()}} that specifies the spatial
distribution of conservation features across planning units. Each row corresponds
to a combination of planning unit and feature. This file is inherited from marxan's
\emph{puvspr.dat}. It must contain the following columns:
\describe{
\item{\code{pu}}{\code{integer} \emph{id} of a planning unit where the conservation feature
listed on the same row occurs.}
\item{\code{feature}}{\code{integer} \emph{id} of each conservation feature.}
\item{\code{amount}}{\code{numeric} amount of the feature in the planning unit. Set
to 1 to work with presence/absence.}
}}

\item{threats}{Object of class \code{\link[=data.frame]{data.frame()}} that specifies the threats to consider in
the optimization exercise. Each row corresponds to a different threats. It must contain
the following columns:
\describe{
\item{\code{id}}{\code{integer} unique identifier for each threat.}
\item{\code{blm_actions}}{\code{numeric} (\strong{optional}) penalty of connectivity between threats.
Default is 0.}
\item{\code{name}}{\code{character} (\strong{optional}) name for each threat.}
}}

\item{dist_threats}{Object of class \code{\link[=data.frame]{data.frame()}} that specifies the spatial
distribution of threats across planning units. Each row corresponds
to a combination of planning unit and threat. It must contain the following
columns:
\describe{
\item{\code{pu}}{\code{integer} \emph{id} of a planning unit where the threat listed on the
same row occurs.}
\item{\code{threat}}{\code{integer} \emph{id} of each threat.}
\item{\code{amount}}{\code{numeric} amount of the threat in the planning unit. Set
to 1 to work with presence/absence. Continuous amount values require
that feature sensitivities to threats be established (more info in
\href{https://prioriactions.github.io/prioriactions/articles/sensitivities.html}{sensitivities}
vignette).}
\item{\code{action_cost}}{\code{numeric} cost of an action to abate the threat
in each planning unit.}
\item{\code{status}}{\code{integer} (\strong{optional}) value that indicates if each action
to abate the threat is available to be selected (0), \emph{locked-in} (2)
as part of the solution, or \emph{locked-out} (3) and therefore excluded from the solution.}
}}

\item{...}{Unused arguments, reserved for future expansion.}

\item{sensitivity}{(\strong{optional}) Object of class \code{\link[=data.frame]{data.frame()}} that specifies
the sensitivity of each feature to each threat. Each row corresponds
to a combination of feature and threat. If not informed, all features
are assumed to be sensitive to all threats.

Sensitivity can be parameterized in two ways: \strong{binary}; the feature is
sensitive or not, or \strong{continuous}; with response curves of the probability of
persistence of the features to threats. For the first case, it is only necessary
to indicate the ids of the threats and the respective features sensitive to them.
In the second case, the response can be parameterized through four values: \emph{\eqn{\delta_1}}, \emph{\eqn{\delta_2}}, \emph{\eqn{\delta_3}}
and \emph{\eqn{\delta_4}}. See
\href{https://prioriactions.github.io/prioriactions/articles/sensitivities.html}{sensitivities}
vignette for more information on continuous sensitivities. Then, the sensitivity input must contain the following columns:
\describe{
\item{\code{feature}}{\code{integer} \emph{id} of each conservation feature.}
\item{\code{threat}}{\code{integer} \emph{id} of each threat.}
\item{\code{delta1}}{\code{numeric} (\strong{optional}) the minimum intensity of the threat at
which the features probability of persistence starts to decline. The more
sensitive the feature is to the threat, the lowest this value will be. Default
is 0.}
\item{\code{delta2}}{\code{numeric} (\strong{optional}) the value of intensity of the threat
over which the feature has a probability of persistence of 0. If it is not
established,it is assumed as the \strong{maximum value of the threat across all planning units}
in the study area.
Note that this might overestimate the sensitivity of features to threats,
as they will only be assumed to disappear from planning units if the
threats reach the maximum intensity value in the study area.}
\item{\code{delta3}}{\code{numeric} (\strong{optional}) minimum probability of persistence of a
features when a threat reaches its maximum intensity value. Default is 0.}
\item{\code{delta4}}{\code{numeric} (\strong{optional}) maximum probability of persistence of a
features in absence threats. Default is 1.}
}
Note that optional parameters \emph{delta1}, \emph{delta2}, \emph{delta3} and \emph{delta4} can be provided independently.}

\item{boundary}{(\strong{optional}) Object of class \code{\link[=data.frame]{data.frame()}} that specifies
the spatial relationship between pair of planning units. Each row corresponds
to a combination of planning unit. This file is inherited from marxan's
\emph{bound.dat}. It must contain the following columns:
\describe{
\item{\code{id1}}{\code{integer} \emph{id} of each planning unit.}
\item{\code{id2}}{\code{integer} \emph{id} of each planning unit.}
\item{\code{boundary}}{\code{numeric} penalty applied in the objective function
when only one of the planning units is present in the solution.}
}}
}
\value{
An object of class \linkS4class{data}.
}
\description{
Create the \linkS4class{data} object with information about the multi-action
conservation planning problem. This function is used to specify all the data
that defines the spatial prioritization problem (planning units data, feature
data, threats data, and their spatial distributions.)
}
\examples{
## set seed for reproducibility
set.seed(14)

## Set prioriactions path
prioriactions_path <- system.file("extdata/example_input/", package = "prioriactions")

## Load in planning unit data
pu_data <- data.table::fread(paste0(prioriactions_path,"/pu.dat"),
                             data.table = FALSE)
head(pu_data)

## Load in feature data
features_data <- data.table::fread(paste0(prioriactions_path,"/features.dat"),
                                   data.table = FALSE)
head(features_data)

## Load in planning unit vs feature data
dist_features_data <- data.table::fread(paste0(prioriactions_path,"/dist_features.dat"),
                                        data.table = FALSE)
head(dist_features_data)

## Load in the threats data
threats_data <- data.table::fread(paste0(prioriactions_path,"/threats.dat"),
                                  data.table = FALSE)
head(threats_data)

## Load in the threats distribution data
dist_threats_data <- data.table::fread(paste0(prioriactions_path,"/dist_threats.dat"),
                                       data.table = FALSE)
head(dist_threats_data)

## Load in the sensitivity data
sensitivity_data <- data.table::fread(paste0(prioriactions_path,"/sensitivity.dat"),
                                      data.table = FALSE)
head(sensitivity_data)

## Load in the boundary data
boundary_data <- data.table::fread(paste0(prioriactions_path,"/boundary.dat"),
                                   data.table = FALSE)
head(boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Summary
print(problem_data)

}
\references{
\itemize{
\item Ball I, Possingham H, Watts, M. \emph{Marxan and relatives: software for spatial
conservation prioritization}. Spatial conservation prioritisation: quantitative
methods and computational tools 2009.
}
}
\seealso{
For more information on the correct format for \emph{Marxan} input data, see the
\href{https://marxansolutions.org}{official \emph{Marxan} website} and Ball \emph{et al.} (2009).
}
