% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{prioriactions}
\alias{prioriactions}
\title{Create and solve multi-actions planning problems}
\usage{
prioriactions(...)
}
\arguments{
\item{...}{arguments inherited from \code{inputData()}, \code{problem()} and \code{solve()} functions.}
}
\value{
An object of class \linkS4class{solution}.
}
\description{
Create and solve a multi-actions planning problem. It can be used
instead of following the sequence of the \code{inputData()}, \code{problem()}
and \code{solve()} functions.
}
\examples{
\donttest{
## This example uses input files included into package.

## set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
s <- prioriactions(pu = sim_pu_data, features = sim_features_data,
                dist_features = sim_dist_features_data,
                threats = sim_threats_data,
                dist_threats = sim_dist_threats_data,
                sensitivity = sim_sensitivity_data,
                boundary = sim_boundary_data,
                model_type = "minimizeCosts",
                time_limit = 50,
                output_file = FALSE,
                cores = 2)

print(s)
}
}
