% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promote.R
\name{promote.library}
\alias{promote.library}
\title{Import one or more libraries and add them to the promote model's
dependency list}
\usage{
promote.library(name, src = "version", version = NULL, user = NULL,
  install = TRUE, auth_token = NULL, url = NULL, ref = "master",
  subdir = NULL)
}
\arguments{
\item{name}{name of the package to be added}

\item{src}{source from which the package will be installed on Promote (github or CRAN)}

\item{version}{version of the package to be added}

\item{user}{Github username associated with the package}

\item{install}{Whether the package should also be installed into the model on the
Promote server; this is typically set to False when the package has already been
added to the Promote base image.}

\item{auth_token}{Personal access token string associated with a private package's repository}

\item{url}{A valid URL pointing to a remote hosted git repository}

\item{ref}{The git branch, tag, or SHA of the package to be installed}

\item{subdir}{The path to the repo subdirectory holding the package to be installed}
}
\description{
Import one or more libraries and add them to the promote model's
dependency list
}
\examples{
\dontrun{
promote.library("MASS")
promote.library(c("wesanderson", "stringr"))
promote.library("hilaryparker/cats")
promote.library("cats", src="github", user="hilaryparker")
promote.library("my_public_package", install=FALSE)
promote.library("my_public_package", src="git", url="https://gitlab.com/userName/rpkg.git")
promote.library("my_proprietary_package", src="github", auth_token=<yourToken>) 
promote.library("testPkg", src="github", user="emessess", auth_token=<yourToken>) 
promote.library("priv_pkg", 
                src="git", 
                url="https://x-access-token:<PersonalAccessToken>ATgithub.com/username/rpkg.git")
promote.library("priv_pkg", 
                 src="git", 
                 url="https://x-access-token:<PersonalAccessToken>ATgitlab.com/username/rpkg.git", 
                 ref="stage")
promote.library("my_package", src="github", auth_token=<yourToken> subdir="/pathToSubdir/")  
}
}
\keyword{import}
