% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPC.R
\name{hmm_LPC}
\alias{hmm_LPC}
\title{hmm_LPC}
\usage{
hmm_LPC(hmm)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}
}
\value{
A vector of length 280.
}
\description{
This feature uses linear predictive coding (LPC) to map each HMM to a \eqn{20 \times 14 = 280} dimensional vector,
where for each of the 20 columns of the HMM, LPC is used to extract a 14 dimensional vector \eqn{D_n}
}
\examples{
h<- hmm_LPC(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Qin, Y., Zheng, X., Wang, J., Chen, M., & Zhou, C. (2015).
Prediction of protein structural class based on Linear Predictive Coding of PSI-BLAST profiles.
Central European Journal of Biology, 10(1).
}
