% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoreauBroto.R
\name{hmm_MB}
\alias{hmm_MB}
\title{hmm_MB}
\usage{
hmm_MB(hmm, lg = 9)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{lg}{The lag value, which indicates the distance between residues.}
}
\value{
A vector of length lg \eqn{\times} 20, by default this is 180.
}
\description{
This feature calculates the normalized Moreau-Broto autocorrelation of each amino acid type, for each distance
d less than or equal to the lag value and greater than or equal to 1.
}
\note{
The lag value must be less than the length of the protein sequence
}
\examples{
h<- hmm_MB(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Liang, Y., Liu, S., & Zhang. (2015).
Prediction of Protein Structural Class Based on Different Autocorrelation Descriptors of Position–Specific Scoring Matrix.
MATCH: Communications in Mathematical and in Computer Chemistry, 73(3), 765–784.
}
