% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleAverage.R
\name{hmm_Single_Average}
\alias{hmm_Single_Average}
\title{hmm_Single_Average}
\usage{
hmm_Single_Average(hmm)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}
}
\value{
A vector of length 400.
}
\description{
This feature groups together rows that are related to the same amino acid. This is done using a vector
\eqn{SA(k)}, in which \eqn{k} spans \eqn{1:400} and \eqn{SA(k) = avg_{i = 1, 2... L}H[i, j] \times \delta(P(i), A(z))},
in which \eqn{H} is the HMM matrix, \eqn{P} in the protein sequence, \eqn{A} is an ordered set of amino acids,
 the variables \eqn{j, z = 1:20}, the variable \eqn{k = j + 20 \times (z-1)} when creating the vector,
and \eqn{\delta()} represents Kronecker's delta.
}
\examples{
h<- hmm_Single_Average(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Nanni, L., Lumini, A., & Brahnam, S. (2014).
An Empirical Study of Different Approaches for Protein Classification. The Scientific World Journal, 2014, 1–17.
}
