% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_cnt_ptable.R
\name{modify_cnt_ptable}
\alias{modify_cnt_ptable}
\alias{modify_cnts_ptable}
\title{Modify a ptable suitable for frequency count variables}
\usage{
modify_cnt_ptable(input, threshold = 0.2, seed = NULL)
}
\arguments{
\item{input}{The ptable-object of class 'ptable', 'ck_params' or data.table}

\item{threshold}{The maximum width of the intervals after modification}

\item{seed}{A seed for the rearrangement of the split intervals}
}
\value{
Returns an object of class \linkS4class{ptable} or a data.table.
}
\description{
\code{\link[=modify_cnt_ptable]{modify_cnt_ptable()}} is a function to modify the standard
ptable for count variables that is generated by \code{\link[=create_cnt_ptable]{create_cnt_ptable()}} or
within the 'cellKey'-package. The noise intervals in
the standard ptable are ordered from -D to D. A modified ptable still has
the same properties as the standard ptable but can ensure a higher
protection of perturbed frequency tables since the noise probabilities are
split and the intervals are rearranged.
}
\details{
In a first step, the noise probabilities larger than a threshold value
will be split. Then, the split noise probabilities are randomly rearranged
using a seed (the modifications is replicable). Finally, the intervals of
the ptable will be adjusted.
}
\examples{
# Original ptable
ptab <- create_cnt_ptable(3, 1)

# modified ptable
ptab_mod <- modify_cnt_ptable(ptab, 0.3, seed = 5467)
ptab_mod@pTable

}
\seealso{
\code{\link[=create_ptable]{create_ptable()}}
}
\author{
Tobias Enderle, \email{tobias.enderle@destatis.de}
}
