% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{time_series_plot}
\alias{time_series_plot}
\title{Plot Time Series of Sensor Concentrations}
\usage{
time_series_plot(sensor_concentrations, text_size = 12)
}
\arguments{
\item{sensor_concentrations}{A data frame (or matrix) containing the output from
the sensor simulation function (e.g., `simulate_sensor_mode()`). It must include:
\describe{
  \item{Group.1}{A character vector of timestamps in the format `"YYYY-MM-DD HH:MM:SS"`.}
  \item{Sensor_1}{A numeric vector of sensor concentration values corresponding to each timestamp.}
}}

\item{text_size}{Default at 12.}
}
\value{
A ggplot object showing the time series of sensor concentrations.
}
\description{
This function plots the time series of sensor concentrations.
}
\examples{
set.seed(123)
sim_dt <- 10
puff_dt <- 10
output_dt <- 60
start_time <- "2024-01-01 12:00:00"
end_time <- "2024-01-01 13:00:00"
emission_rate <- 3.5
wind_data <- data.frame(
  wind_u = runif(3601, min = -3, max = 0.7),
  wind_v = runif(3601, min = -3, max = 1.5)
)
source_coords <- c(0, 0, 2.5)
sensor_coords <- matrix(c(-6.525403221327715e-15, -35.52264, 2.01775), ncol = 3, byrow = TRUE)

out <- simulate_sensor_mode(
  start_time, end_time, source_coords,
  emission_rate, wind_data, sensor_coords, sim_dt, puff_dt, output_dt, puff_duration = 1200
)

time_series_plot(out)
}
