% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_pmc_list.R
\name{data_pmc_list}
\alias{data_pmc_list}
\title{Download and Process 'PMC Open Access' File List}
\usage{
data_pmc_list(
  path = NULL,
  use_persistent_storage = FALSE,
  force_install = FALSE,
  timeout = 300
)
}
\arguments{
\item{path}{A character string specifying the directory path where data should 
be stored. If not provided and persistent storage is requested, it defaults to 
a system-appropriate persistent location managed by `rappdirs`.}

\item{use_persistent_storage}{A logical value indicating whether to use persistent
storage. If TRUE and no path is provided, data will be stored in a system-appropriate 
location. Defaults to FALSE, using a temporary directory.}

\item{force_install}{A logical value indicating whether to force re-downloading 
of the data even if it already exists locally.}

\item{timeout}{An integer indicating the timeout in seconds for the download.
Defaults to 300 seconds.}
}
\value{
A data frame containing the processed PMC open access file list.
}
\description{
This function downloads the 'PubMed Central' (PMC) open access file list from the
'National Center for Biotechnology Information' (NCBI) and processes it for use.
}
\details{
The data is sourced from the specified URL and stored locally for subsequent use.
By default, the data is stored in a temporary directory. Users can opt into 
persistent storage by setting `use_persistent_storage` to TRUE and optionally 
specifying a path.
}
\examples{
\donttest{
if (interactive()) {
  data <- data_pmc_list()
}
}

}
