% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.pwrrasch.R
\name{plot.pwrrasch}
\alias{plot.pwrrasch}
\title{Plot Statistical Power Curve}
\usage{
\method{plot}{pwrrasch}(x, plot.sig.level = TRUE, type = c("b", "b"),
  pch = c(19, 17), lty = c(1, 3), lwd = c(1, 1), legend = "topleft",
  bty = "o", ...)
}
\arguments{
\item{x}{\code{pwrrasch} object.}

\item{plot.sig.level}{If \code{TRUE}, nominal significance level is plotted.}

\item{type}{Vector indicating type of plot for the statistica power curve
and the type 1 risk curve.}

\item{pch}{Vector indicating plotting symbol for the statistical power curve
and the type 1 risk curve.}

\item{lty}{Vector indicating line type for the statistical power curve
and the type 1 risk curve.}

\item{lwd}{Vector indicating line width for the statistical power curve
and the type 1 risk curve.}

\item{legend}{Location of the legend. If \code{FALSE}, legend is omitted.}

\item{bty}{Type of box to be drawn around the legend.}

\item{...}{Additional arguments affecting the summary produced.}
}
\description{
Generic \code{plot} function for the \code{pwrrasch} object, which
plots the statistical power curve relating statistical power to sample size
}
\details{
Graphical parameters are:
\itemize{
 \item{\code{type}} The following values are possible: \code{"p"} for points,
                    \code{"l"} for lines, \code{"b"} for both point and lines
 \item{\code{pch}} see \link[graphics]{points}
 \item{\code{lty}} Line types can  be specified as an integer (\code{0} = blank, \code{1} = solid,
                   \code{2} = dashed, \code{3} = dotted, \code{4} = dotdash, \code{5} = longdash,
                   \code{6} = twodash)
 \item{\code{lwd}} Positive numbers indicating line widths
 \item{\code{legend}} Either the x and y coordinates to be used to position the legend or
                      keyword from the list \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"},
                      \code{"left"}, \code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"}
                      and \code{"center"}
 \item{\code{bty}} Allowed values are "o" (draw box around legend) and "n" (do not draw box around legend).
}
}
\examples{
\dontrun{

# item parameters
ipar2 <- ipar1 <- seq(-3, 3, length.out = 20)
# model differential item function (DIF)
ipar2[10] <- ipar1[11]
ipar2[11] <- ipar1[10]
# simulation for b = 100, 200, 300, 400, 500
simres <- pwr.rasch(seq(100, 500, by = 100), ipar = list(ipar1, ipar2))
plot(simres)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Jan Steinfeld \email{jan.steinfeld@univie.ac.at}
}
\references{
Kubinger, K. D., Rasch, D., & Yanagida, T. (2009). On designing data-sampling for Rasch model
calibrating an achievement test. \emph{Psychology Science Quarterly, 51}, 370-384.

Kubinger, K. D., Rasch, D., & Yanagida, T. (2011). A new approach for testing the Rasch model.
\emph{Educational Research and Evaluation, 17}, 321-333.
}

