% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funq_plot.R
\name{funq_plot}
\alias{funq_plot}
\title{Functional quantile plot}
\usage{
funq_plot(
  data,
  x = NULL,
  n = 100,
  min_bin_size = NULL,
  overlap = NULL,
  color = "#002f2f",
  fill = "#2f4f4f",
  auto_fill = TRUE,
  ncols = NULL,
  xmarker = NULL,
  qmarker = NULL,
  show_bins = FALSE,
  xlim = NULL,
  connect = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{color}{The color to use for the line charts}

\item{fill}{The fill color to use for the areas}

\item{auto_fill}{If \code{TRUE}, use a different color for each category}

\item{ncols}{The number of column to be used in the layout}

\item{xmarker}{\code{numeric}, the x marker.}

\item{qmarker}{\code{numeric}, the quantile marker to use that is translated in a x value.}

\item{show_bins}{if \code{TRUE} a rug is added to the plot}

\item{xlim}{\code{numeric}, the limits of the x-axis.}

\item{connect}{if \code{TRUE} subsequent medians are connected.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A ggplot object with the plots
}
\description{
\code{\link[=funq_plot]{funq_plot()}} conditions on variable \code{x} with quantile binning and
plots the median and interquartile range of numerical variables and level frequency
of the other variables as a function the \code{x} variable.
}
\details{
By highlighting and connecting the median values it creates a functional view of the data.
What is the (expected) median given a certain value of \code{x}?

It \code{qbin}s the \code{x} variable and plots the medians of the qbins vs the other variables, thereby
creating a functional view of \code{x} to the rest of the data,
calculating the statistics for each bin, hence the name \code{funq_plot}.
}
\examples{
funq_plot(iris, "Sepal.Length", xmarker=5.5)

\donttest{

  funq_plot(
    iris,
    x = "Sepal.Length",
    xmarker=5.5,
    overlap = TRUE
  )


  data("diamonds", package="ggplot2")
  funq_plot(diamonds[1:7], "carat", xlim=c(0,2))

  if (require(palmerpenguins)){
    funq_plot(
      penguins[1:7],
      x = "body_mass_g",
      xmarker=4650,
      ncol = 3
    )
  }


}
}
\seealso{
Other conditional quantile plotting functions: 
\code{\link{cond_barplot}()},
\code{\link{cond_boxplot}()},
\code{\link{cond_heatmap}()}
}
\concept{conditional quantile plotting functions}
