% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DunnettGLMbMDD.R
\name{Dunnett.GLM.bMDD}
\alias{Dunnett.GLM.bMDD}
\title{Dunnett.GLM bootstrap MDD (bMDD)}
\usage{
Dunnett.GLM.bMDD(
  groups,
  counts,
  control.name = NULL,
  alpha = 0.05,
  shift.step = -0.25,
  bootstrap.runs = 200,
  power = 0.8,
  max.iterations = 1000,
  use.fixed.random.seed = NULL,
  Dunnett.GLM.zero.treatment.action = "log(x+1)",
  show.progress = TRUE,
  show.results = TRUE
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{shift.step}{Step of shift (negative as a reduction is assumed)}

\item{bootstrap.runs}{Number of bootstrap runs}

\item{power}{Proportion of bootstrap.runs that return significant differences}

\item{max.iterations}{Max. number of iterations to not get stuck in the while loop}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{Dunnett.GLM.zero.treatment.action}{Dunnett.GLM method to be used for treatments only containing zeros}

\item{show.progress}{Show progress for each shift of lambda}

\item{show.results}{Show results}
}
\value{
Data frame with results from bMDD analysis
}
\description{
The basic idea of the calculation of bootstrap MDD (bMDD) using the Dunnett.GLM approach
is to shift the lambda parameter of Poisson distribution until there is a certain proportion of
results significantly different from the control.
}
\examples{
Daphnia.counts	# example data provided alongside the package

# Test Dunnett.GLM bootstrap MDD
Dunnett.GLM.bMDD(groups = Daphnia.counts$Concentration,
	counts = Daphnia.counts$Number_Young,
	control.name = NULL,
	alpha = 0.05,
	shift.step = -1,		# Caution: big step size for testing
	bootstrap.runs = 5,	# Caution: low number of bootstrap runs for testing
	power = 0.8,
	max.iterations = 1000,
	use.fixed.random.seed = 123,  #fixed seed for reproducible results
	Dunnett.GLM.zero.treatment.action = "log(x+1)",
	show.progress = TRUE,
	show.results = TRUE)
}
