% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hideLocation.R
\name{hideLocation}
\alias{hideLocation}
\title{\code{hideLocation} Obfuscating the true location of the real data.}
\usage{
hideLocation(trueLoc, nSubjects)
}
\arguments{
\item{trueLoc}{A vector of one or more numbers in the set {1, 2, ..., nSubjects} whose locations are to be hidden.}

\item{nSubjects}{An integer larger than 1 used to define the set {1, 2, ..., nSubjects}.}
}
\value{
Returns a character vector, each element being a string
containing an obscure calculation which, if parsed and evaluated, would return
the value of the corresponding number in \code{trueLoc}.
}
\description{
Hides the true location of the data as a non-obvious calculation string.
}
\examples{
trueLoc <- hideLocation(3,100)
trueLoc
revealLocation(trueLoc)

n <- 200
trueLoc <- sample(1:n, 3)
trueLoc
ans <- hideLocation(trueLoc , n)
ans
revealLocation(ans)

}
\seealso{
\code{\link{revealLocation}}
}
