% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{dQspray}
\alias{dQspray}
\title{Partial differentiation}
\usage{
dQspray(qspray, orders)
}
\arguments{
\item{qspray}{object of class \code{qspray}}

\item{orders}{integer vector, the orders of the differentiation; e.g. 
\code{c(2, 0, 1)} means that you differentiate two times with respect to 
\eqn{x}, you do not differentiate with respect to \eqn{y}, and you 
differentiate one time with respect to \eqn{z}}
}
\value{
A \code{qspray} object.
}
\description{
Partial differentiation of a \code{qspray} polynomial.
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
qspray <- x + 2*y  + 3*x*y
dQspray(qspray, c(1, 1))
derivQspray(derivQspray(qspray, 1), 2)
}
