% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp_kinship.R
\name{decomp_kinship}
\alias{decomp_kinship}
\title{Calculate eigen decomposition of kinship matrix}
\usage{
decomp_kinship(kinship, cores = 1)
}
\arguments{
\item{kinship}{A square matrix, or a list of square matrices.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
The eigen values and the \strong{transposed} eigen vectors,
as a list containing a vector \code{values} and a matrix
\code{vectors}.
}
\description{
Calculate the eigen decomposition of a kinship matrix, or of a list of such matrices.
}
\details{
The result contains an attribute \code{"eigen_decomp"}.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[1:30,18:19] # subset to 30 individuals and two chromosomes}
map <- insert_pseudomarkers(iron$gmap, step=1)
probs <- calc_genoprob(iron, map, error_prob=0.002)
K <- calc_kinship(probs)

Ke <- decomp_kinship(K)

}
