% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fst_genoprob}
\alias{summary.fst_genoprob}
\title{Summary of an fst_genoprob object}
\usage{
\method{summary}{fst_genoprob}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"fst_genoprob"}, as output by \code{\link[=fst_genoprob]{fst_genoprob()}}.}

\item{...}{Ignored.}
}
\description{
Summarize an fst_genoprob object
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[1:8,c(1,2)]}
pr <- calc_genoprob(grav2)
dir <- tempdir()
fpr <- fst_genoprob(pr, "grav2", dir)

# summary of fst_genoprob object
summary(fpr)

# clean up: remove all the files we created
unlink(fst_files(fpr))
}
\keyword{utilities}
