% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_probs.R
\name{read_probs}
\alias{read_probs}
\title{Read genotype probability object from file}
\usage{
read_probs(
  chr = NULL,
  start_val = NULL,
  end_val = NULL,
  datapath,
  allele = TRUE,
  method,
  probdir = "genoprob"
)
}
\arguments{
\item{chr}{vector of chromosome identifiers}

\item{start_val, end_val}{start and end values in Mbp}

\item{datapath}{name of folder with Derived Data}

\item{allele}{read haplotype allele probabilities (if \code{TRUE}) or diplotype allele-pair probabilities (if \code{FALSE})}

\item{method}{method of genoprob storage}

\item{probdir}{genotype probability directory (default \code{"genoprob"})}
}
\value{
list with \code{probs} = large object of class \code{\link[qtl2]{calc_genoprob}} and \code{map} = physical map for selected \code{chr}
}
\description{
Read object from file stored according to method.
}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
