% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixtoimage.R
\name{matrixtoimage}
\alias{matrixtoimage}
\title{Converts matrix back to image}
\usage{
matrixtoimage(object, show = TRUE, bkg = "thistle", axes = FALSE,
  xlab = "", ylab = "", ...)
}
\arguments{
\item{object}{S3 object of working TLC.}

\item{show}{Boolean, default TRUE. Shows the plot of the image.}

\item{bkg}{If \code{show} is TRUE, then defines background color. Default is "thistle".}

\item{axes}{Boolean, default FALSE. Shows x,y axes if TRUE.}

\item{xlab}{Label of the x-axis.}

\item{ylab}{Label of the y-axis.}

\item{...}{Additional graphical parameters.}
}
\value{
Returns image as matrix suitable for \code{plot}, or other graphics functinos.
}
\description{
Using S3 qtlc object, extracts the matrix and converts to image plot.
}
\examples{
# Converts test image to matrix,
# then matrix back to image.
fname01 <- system.file("extdata", "testTIFF.tiff", package="qtlc")
testTLC <- createTLC(fname01, RGB=FALSE)
print(testTLC)
matrixtoimage(testTLC, bkg="white")

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}

