% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showtlc2D.qtlc.R
\name{showtlc2D.qtlc}
\alias{showtlc2D.qtlc}
\title{Show TLC matrix as 2D plot}
\usage{
\method{showtlc2D}{qtlc}(object, specific = NULL, RGB = "", main = "",
  correction = TRUE, grey = FALSE, ...)
}
\arguments{
\item{object}{S3 object of the working TLC}

\item{specific}{Matrix of the specific spot (from object$spot_matrices)}

\item{RGB}{RGB matrices (if they are present in the object) are separated on the plot. Values of the RGB = "R", or "G", or "B".}

\item{main}{Main title of the plot.}

\item{correction}{Experimental option, currently not in use.}

\item{grey}{Boolean, if TRUE, then TLC plate is greyscaled. Default value is FALSE.}

\item{...}{Additional graphical parameters}
}
\value{
None
}
\description{
Using TLC matrix width, height, and intensity parameters this function plot 2D heatmap of the TLC matrix.
}
\examples{
\dontrun{
showtlc2D(object, specific=object$spot_matrices[3], grey=TRUE)
}

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}

