% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feim.R
\name{feim}
\alias{feim}
\alias{print.qtlpoly.feim}
\title{Fixed-effect interval mapping (FEIM)}
\usage{
feim(
  data = data,
  pheno.col = NULL,
  w.size = 15,
  sig.lod = 7,
  d.sint = 1.5,
  plot = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.feim}(x, pheno.col = NULL, sint = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{pheno.col}{a numeric vector with the phenotype columns to be analyzed; if \code{NULL} (default), all phenotypes from \code{'data'} will be included.}

\item{w.size}{a number representing the window size (in centiMorgans) to be avoided on either side of QTL already in the model when looking for a new QTL, e.g. 15 (default).}

\item{sig.lod}{the vector of desired significance LOD thresholds (usually permutation-based) for declaring a QTL for each trait, e.g. 5 (default); if a single value is provided, the same LOD threshold will be applied to all traits.}

\item{d.sint}{a \eqn{d} value to subtract from logarithm of the odds (\eqn{LOD-d}) for support interval calculation, e.g. \eqn{d=1.5} (default) represents approximate 95\% support interval.}

\item{plot}{a suffix for the file's name containing plots of every algorithm step, e.g. "remim" (default); if \code{NULL}, no file is produced.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.feim} to be printed.}

\item{sint}{whether \code{"upper"} or \code{"lower"} support intervals should be printed; if \code{NULL} (default), QTL peak information will be printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.feim} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{LRT}{a vector containing LRT values.}
    \item{LOD}{a vector containing LOD scores.}
    \item{AdjR2}{a vector containing adjusted \eqn{R^2}.}
    \item{qtls}{a data frame with information from the mapped QTL.}
    \item{lower}{a data frame with information from the lower support interval of mapped QTL.}
    \item{upper}{a data frame with information from the upper support interval of mapped QTL.}
}
\description{
Performs interval mapping using the single-QTL, fixed-effect model proposed by Hackett et al. (2001).
}
\examples{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 5)

  # Perform remim
  feim.mod = feim(data = data, sig.lod = 7)

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.

    Hackett CA, Bradshaw JE, McNicol JW (2001) Interval mapping of quantitative trait loci in autotetraploid species, \emph{Genetics} 159: 1819-1832.
}
\seealso{
\code{\link[qtlpoly]{permutations}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
