% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_names.R
\name{change_names}
\alias{change_names}
\title{Change names of columns}
\usage{
change_names(data, labelset, from, to)
}
\arguments{
\item{data}{The data frame that you want to change the column names of.}

\item{labelset}{The data frame containing column names that you want to change and
what you want them to be changed to.}

\item{from}{The name of the column in the label set data frame containing the
original column names.}

\item{to}{The name of the column in the label set data frame containing new
column names that the original column names will be changed to.}
}
\value{
A data frame containing new column names.
}
\description{
Using a new data frame of labels, change column names in one function.
Helpful if column names are shorthands or contain spaces and characters that
are not supported in column names in R.
}
\examples{
#creating data set
Sites <- c("One", "Two", "Three", "Four", "Five")
Acrop <- c(0.1, 0.4, 0.9, 0.2, 0.5)
Gardin <- c(0.4, 0.9, 0.5, 0.23, 0.8)
Psam <- c(0.9, 0.5, 0.8, 0.1, 0.4)
Lepta <- c(0.5, 0.7, 0.8, 0.2, 0.9)
coral_cover <- data.frame(Sites, Acrop, Gardin, Psam, Lepta)

#creating label data frame
species_short <- c("Acrop", "Gardin", "Psam", "Lepta")
species_long <- c("Acropora", "Gardineroseris", "Psammocora", "Leptastrea")
coral_labels <- data.frame(species_short, species_long)

change_names(coral_cover, coral_labels, "species_short", "species_long")

}
