% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_foreign.R
\name{as_sf}
\alias{as_sf}
\alias{as_vect}
\alias{as_character}
\title{Convert to other R spatial objects}
\usage{
as_sf(x)

as_vect(x)

as_character(x)
}
\arguments{
\item{x}{Quadtree object}
}
\value{
an object of class \code{sf} or \code{SpatVector}, or a Well-Known Text (WKT) \code{character} representation
}
\description{
Convert to other R spatial objects
}
\examples{
\dontshow{if (all(sapply(c("sf"), function(x) !inherits(try(requireNamespace(x, quietly=TRUE), silent=TRUE), 'try-error')))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
library(quadtree)
habitat <- terra::rast(system.file("extdata", "habitat.tif", package="quadtree"))

qt <- quadtree(habitat, .1)
sf <- as(qt, "sf")
sr <- as(qt, "SpatRaster")
sv <- as(qt, "SpatVector")
ch <- as(qt, "character")
}
