% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_distributions.R
\name{fetch_distributions}
\alias{fetch_distributions}
\title{Download distribution data for a survey from Qualtrics}
\usage{
fetch_distributions(surveyID)
}
\arguments{
\item{surveyID}{String. Unique survey ID for the distribution data you want to download.}
}
\description{
Download distribution data for a survey from Qualtrics
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

surveys <- all_surveys()
distributions <- fetch_distributions(surveys$id[1])
}

}
