% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-MovingBlocks.R
\docType{class}
\encoding{latin1}
\name{MovingBlocks-class}
\alias{MovingBlocks-class}
\alias{MovingBlocks}
\title{Class for Moving Blocks Bootstrap implementation.}
\description{
\code{MovingBlocks} is an S4 class that implements the moving blocks
bootstrap described in Künsch (1989).
}
\details{
\code{MovingBlocks} extends the S4 class
\code{\link{BootPos}} and the remarks made in its documentation
apply here as well.

The Moving Blocks Bootstrap method of Künsch (1989) resamples blocks
randomly, with replacement from the collection of overlapping blocks of
length \code{l} that start with observation 1, 2, \ldots, \code{N-l+1}.
A more precise description of the procedure can also be found in
Lahiri (1999), p. 389.
}
\references{
Künsch, H. R. (1989). The jackknife and the bootstrap for general stationary
observations. \emph{The Annals of Statistics}, \bold{17}, 1217--1261.
}
\seealso{
\code{\link{getPositions-MovingBlocks}}
}
\keyword{S4-classes}
