% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data-wheatprices}
\alias{data-wheatprices}
\alias{wheatprices}
\title{Beveridge's Wheat Price Index (detrended and demeaned), 1500--1869}
\format{
A univariate time series \eqn{(z_t)} with 370 observations; a \code{ts} object.
}
\description{
Contains a detrended and demeaned version of the well-known Beveridge Wheat
Price Index which gives annual price data from 1500 to 1869, averaged over
many locations in western and central Europe [cf. Beveridge (1921)].
The index series \eqn{x_t} was detrended as proposed by Granger (1964), p. 21, by
letting
\deqn{y_t := \frac{x_t}{\sum_{j=-15}^{15} x_{t+j}},}
where \eqn{x_t := x_1, t < 1} and \eqn{x_t := x_n, t > n}.
The time series in the data set is also demeaned by letting
\deqn{z_t := y_t - n^{-1} \sum_{t=1}^n y_t.}
}
\details{
The index data cited in Beveridge's paper was taken from \code{bev} in the
\code{tseries} package.
}
\examples{
plot(wheatprices)
}
\references{
Beveridge, W. H. (1921). Weather and Harvest Cycles. \emph{The Economic Journal},
31(124):429--452.

Granger, C. W. J. (1964). \emph{Spectral Analysis of Economic Time Series}.
Princeton University Press, Princeton, NJ.
}
\keyword{data}
