% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{blip.learn}
\alias{blip.learn}
\title{Learns a BN}
\usage{
blip.learn(dat, scorer.method = "is", solver.method = "winasobs",
  indeg = 6, time = 3600, allocated = 80, scorefunction = "bic",
  alpha = 1, cores = 1, verbose = 0)
}
\arguments{
\item{dat}{dataframe from which to learn the parent sets.(required)}

\item{scorer.method}{Method to be used for scoring the parent sets. Possible values: "is" (independence selection), "sq" (sequential selection). (default: is)}

\item{solver.method}{Method to be used for structure exploration. Possible values: "winasobs", "winobs", "asobs", "obs". (default: winasobs)}

\item{indeg}{Maximum number of parents (default: 6)}

\item{time}{Execution time (default: 3600)}

\item{allocated}{Percentage of the total execution time dedicated to parent set exploration (default: 80)}

\item{scorefunction}{Chosen score function. Possible choices: BIC, BDeu (default: bic)}

\item{alpha}{(if BDeu is chosen) equivalent sample size parameter (default: 1.0)}

\item{cores}{Number of machine cores to use. If 0, all are used. (default: 1)}

\item{verbose}{Verbose level (default: 0)}
}
\value{
The learned Bayesian network in the bnlearn format.
}
\description{
Fully learns a Bayesian networks.
}
\details{
The input data is required to be complete and discrete. 
Accordingly missing values in the input data.frame will be ignored, and all numeric values will be converted to integers.
}
\examples{
bn <- blip.learn(child, time=3)
}
