% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r3js.R
\name{r3js}
\alias{r3js}
\title{Plot a data3js object}
\usage{
r3js(
  data3js,
  rotation = c(-1.45, 0, -2.35),
  zoom = 2,
  translation = c(0, 0, 0),
  styles = list(),
  title = "R3JS viewer",
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{rotation}{Plot starting rotation as an XYZ Euler rotation}

\item{zoom}{Plot starting zoom factor}

\item{translation}{Plot starting translation}

\item{styles}{List of styles controlling elements of the plot, see examples}

\item{title}{Title for the viewer}

\item{...}{Additional arguments to pass to \code{htmlwidgets::createWidget()}}
}
\value{
Returns an html widget of the plot
}
\description{
This function takes the assembled data3js object and plots it as an
htmlwidget.
}
\examples{
# Control toggle button appearance
r3js(
  plot3js(
    x = iris$Sepal.Length,
    y = iris$Sepal.Width,
    z = iris$Petal.Length,
    col = rainbow(3)[iris$Species],
    xlab = "Sepal Length",
    ylab = "Sepal Width",
    zlab = "Petal Length",
    toggle = iris$Species
  ),
  styles = list(
    togglediv = list(
      bottom = "4px",
      right = "4px"
    ),
    toggles = list(
      setosa = list(
        on  = list(backgroundColor = colorspace::darken(rainbow(3)[1], 0.1), color = "white"),
        off = list(backgroundColor = colorspace::lighten(rainbow(3)[1], 0.8), color = "white")
      ),
      versicolor = list(
        on  = list(backgroundColor = colorspace::darken(rainbow(3)[2], 0.1), color = "white"),
        off = list(backgroundColor = colorspace::lighten(rainbow(3)[2], 0.8), color = "white")
      ),
      virginica = list(
        on  = list(backgroundColor = colorspace::darken(rainbow(3)[3], 0.1), color = "white"),
        off = list(backgroundColor = colorspace::lighten(rainbow(3)[3], 0.8), color = "white")
      )
    )
  ),
  zoom = 1.5
)

}
