% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotRetroRecruits.R
\name{SSplotRetroRecruits}
\alias{SSplotRetroRecruits}
\title{Make squid plot of retrospectives of recruitment deviations.}
\usage{
SSplotRetroRecruits(
  retroSummary,
  endyrvec,
  cohorts,
  ylim = NULL,
  uncertainty = FALSE,
  labels = c("Recruitment deviation", "Recruitment (billions)",
    "relative to recent estimate", "Age"),
  main = "Retrospective analysis of recruitment deviations",
  mcmcVec = FALSE,
  devs = TRUE,
  relative = FALSE,
  labelyears = TRUE,
  legend = FALSE,
  leg.ncols = 4
)
}
\arguments{
\item{retroSummary}{List object created by \code{\link[=SSsummarize]{SSsummarize()}} that
summarizes the results of a set of retrospective analysis models.ss}

\item{endyrvec}{Vector of years representing the final year of values to
show for each model.}

\item{cohorts}{Which cohorts to show in plot.}

\item{ylim}{Limits of y-axis.}

\item{uncertainty}{Show uncertainty intervals around lines? (This can get a
bit busy.)}

\item{labels}{Vector of plot labels.}

\item{main}{Title for plot.}

\item{mcmcVec}{Either vector of TRUE/FALSE values indicating which models
use MCMC.  Or single value applied to all models.}

\item{devs}{Plot deviations instead of absolute recruitment values?}

\item{relative}{Show deviations relative to most recent estimate or relative
to 0.}

\item{labelyears}{Label cohorts with text at the end of each line?}

\item{legend}{Add a legend showing which color goes with which line (as
alternative to \code{labelyears}).}

\item{leg.ncols}{Number of columns for the legend.}
}
\description{
Inspired by Jim Ianelli and named by Sean Cox, the squid plot is a way to
examine retrospective patterns in estimation of recruitment deviations.
}
\examples{
\dontrun{
# run retrospective analysis
SS_doRetro(olddir = "2013hake_12", years = 0:-10)
# read in output
retroModels <- SSgetoutput(dirvec = paste("retrospectives/retro", -10:0, sep = ""))
# summarize output
retroSummary <- SSsummarize(retroModels)

# set the ending year of each model in the set
endyrvec <- retroModels[[1]][["endyr"]] - 10:0
# make comparison plot
pdf("retrospectives/retrospective_comparison_plots.pdf")
SSplotComparisons(retroSummary, endyrvec = endyrvec, new = FALSE)
dev.off()

# make Squid Plot of recdev retrospectives
pdf("retrospectives/retrospective_dev_plots.pdf", width = 7, height = 10)
par(mfrow = c(2, 1))
# first scaled relative to most recent estimate
SSplotRetroRecruits(retroSummary,
  endyrvec = endyrvec, cohorts = 1999:2012,
  relative = TRUE, legend = FALSE
)
# second without scaling
SSplotRetroDevs(retroSummary,
  endyrvec = endyrvec, cohorts = 1999:2012,
  relative = FALSE, legend = FALSE
)
dev.off()
}

}
\references{
Ianelli et al. (2011) Assessment of the walleye pollock stock in
the Eastern Bering Sea.
(Figure 1.31, which is on an absolute, rather than log scale.)
}
\seealso{
\code{\link[=SSsummarize]{SSsummarize()}}
}
\author{
Ian Taylor
}
