% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotSummaryF.R
\name{SSplotSummaryF}
\alias{SSplotSummaryF}
\title{Plot the summary F (or harvest rate).}
\usage{
SSplotSummaryF(
  replist,
  yrs = "all",
  Ftgt = NA,
  ylab = "Summary Fishing Mortality",
  plot = TRUE,
  print = FALSE,
  plotdir = "default",
  verbose = TRUE,
  uncertainty = TRUE,
  add = FALSE,
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  res = 300,
  ptsize = 10,
  mar = NULL
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{yrs}{Which years to include.}

\item{Ftgt}{Target F where horizontal line is shown.}

\item{ylab}{Y-axis label.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{plotdir}{Directory where PNG files will be written. By default it will
be the directory where the model was run.}

\item{verbose}{Verbose output to R console?}

\item{uncertainty}{Show 95\% uncertainty intervals around point estimates?}

\item{add}{add to existing plot}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. The default is \code{pwidth=6.5}.}

\item{pheight}{Height of plots printed to png files in units of \code{punits}.
Default is designed to allow two plots per page, with \code{pheight_tall} used
for plots that work best with a taller format and a single plot per page.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" (centimeters), or "mm" (millimeters).
The default is \code{punits="in"}.}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for plotted text in plots printed to files (see
\code{help("png")} in R for details).}

\item{mar}{Either NULL to allow the default (which depends on whether the main title is included or not) or a numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot, which is passed to \code{par()}.}
}
\description{
Plots the summary F (or harvest rate) as set up in the starter file Needs a
lot of work to be generalized
}
\seealso{
\code{\link[=SSplotTimeseries]{SSplotTimeseries()}}
}
\author{
Allan Hicks
}
