% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSunavailableSpawningOutput.R
\name{SSunavailableSpawningOutput}
\alias{SSunavailableSpawningOutput}
\title{Plot unavailable spawning output}
\usage{
SSunavailableSpawningOutput(
  replist,
  plot = TRUE,
  print = FALSE,
  plotdir = "default",
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  res = 300,
  ptsize = 10,
  cex.main = 1
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{plotdir}{Directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for PNG file}

\item{cex.main}{Character expansion for plot titles}
}
\description{
Calculate and plot the unavailable spawning output- separating out ones that
are unavailable because they're too small to be selected from ones that are
too big to be selected
}
\author{
Megan Stachura, Andrew Cooper, Andi Stephens, Neil Klaer, Ian G. Taylor
}
