% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.2_Distr_DistrCollection_Classes.R
\name{Distr}
\alias{Distr}
\title{Distr-class: Class `Distr`}
\description{
R6 Class for Distribution Objects
}
\examples{
# Normal
set.seed(123)
data1 <- rnorm(100, mean = 5, sd = 2)
parameters1 <- list(mean = 5, sd = 2)
distr1 <- Distr$new(x = data1, name = "normal", parameters = parameters1,
                    sd = 2, n = 100, loglik = -120)
distr1$plot()

# Log-normal
data2 <- rlnorm(100, meanlog = 1, sdlog = 0.5)
parameters2 <- list(meanlog = 1, sdlog = 0.5)
distr2 <- Distr$new(x = data2, name = "log-normal", parameters = parameters2,
                    sd = 0.5, n = 100, loglik = -150)
distr2$plot()

# Geometric
data3 <- rgeom(100, prob = 0.3)
parameters3 <- list(prob = 0.3)
distr3 <- Distr$new(x = data3, name = "geometric", parameters = parameters3,
                    sd = sqrt((1 - 0.3) / (0.3^2)), n = 100, loglik = -80)
distr3$plot()

# Exponential
data4 <- rexp(100, rate = 0.2)
parameters4 <- list(rate = 0.2)
distr4 <- Distr$new(x = data4, name = "exponential", parameters = parameters4,
                    sd = 1 / 0.2, n = 100, loglik = -110)
distr4$plot()

# Poisson
data5 <- rpois(100, lambda = 3)
parameters5 <- list(lambda = 3)
distr5 <- Distr$new(x = data5, name = "poisson", parameters = parameters5,
                    sd = sqrt(3), n = 100, loglik = -150)
distr5$plot()

# Chi-square
data6 <- rchisq(100, df = 5)
parameters6 <- list(df = 5)
distr6 <- Distr$new(x = data6, name = "chi-squared", parameters = parameters6,
                    sd = sqrt(2 * 5), n = 100, loglik = -130)
distr6$plot()

# Logistic
data7 <- rlogis(100, location = 0, scale = 1)
parameters7 <- list(location = 0, scale = 1)
distr7 <- Distr$new(x = data7, name = "logistic", parameters = parameters7,
                    sd = 1 * sqrt(pi^2 / 3), n = 100, loglik = -140)
distr7$plot()

# Gamma
data8 <- rgamma(100, shape = 2, rate = 0.5)
parameters8 <- list(shape = 2, rate = 0.5)
distr8 <- Distr$new(x = data8, name = "gamma", parameters = parameters8,
                    sd = sqrt(2 / (0.5^2)), n = 100, loglik = -120)
distr8$plot()

# f
data9 <- rf(100, df1 = 5, df2 = 10)
parameters9 <- list(df1 = 5, df2 = 10)
df1 <- 5
df2 <- 10
distr9 <- Distr$new(x = data9, name = "f", parameters = parameters9,
                    sd = sqrt(((df2^2 * (df1 + df2 - 2)) /
                               (df1 * (df2 - 2)^2 * (df2 - 4)))),
                    n = 100, loglik = -150)
distr9$plot()

# t
data10 <- rt(100, df = 10)
parameters10 <- list(df = 10)
distr10 <- Distr$new(x = data10, name = "t", parameters = parameters10,
                     sd = sqrt(10 / (10 - 2)), n = 100, loglik = -120)
distr10$plot()

# negative binomial
data11 <- rnbinom(100, size = 5, prob = 0.3)
parameters11 <- list(size = 5, prob = 0.3)
distr11 <- Distr$new(x = data11, name = "negative binomial",
                     parameters = parameters11,
                     sd = sqrt(5 * (1 - 0.3) / (0.3^2)),
                     n = 100, loglik = -130)
distr11$plot()
}
\seealso{
\code{\link{distribution}}, \code{\link{FitDistr}}, \code{\link{DistrCollection}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{x}}{Numeric vector of data values.}

\item{\code{name}}{Character string representing the name of the distribution.}

\item{\code{parameters}}{List of parameters for the distribution.}

\item{\code{sd}}{Numeric value representing the standard deviation of the distribution.}

\item{\code{n}}{Numeric value representing the sample size.}

\item{\code{loglik}}{Numeric value representing the log-likelihood.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Distr-new}{\code{Distr$new()}}
\item \href{#method-Distr-plot}{\code{Distr$plot()}}
\item \href{#method-Distr-clone}{\code{Distr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distr-new"></a>}}
\if{latex}{\out{\hypertarget{method-Distr-new}{}}}
\subsection{Method \code{new()}}{
Initialize the fiels of the `Distribution` object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distr$new(x, name, parameters, sd, n, loglik)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Numeric vector of data values.}

\item{\code{name}}{Character string representing the name of the distribution.}

\item{\code{parameters}}{List of parameters for the distribution.}

\item{\code{sd}}{Numeric value representing the standard deviation of the distribution.}

\item{\code{n}}{Numeric value representing the sample size.}

\item{\code{loglik}}{Numeric value representing the log-likelihood.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distr-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Distr-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the distribution with histogram and fitted density curve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distr$plot(
  main = NULL,
  xlab = NULL,
  xlim = NULL,
  xlim.t = TRUE,
  ylab = NULL,
  line.col = "red",
  fill.col = "lightblue",
  border.col = "black",
  box = TRUE,
  line.width = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{main}}{Character string for the main title of the plot. Defaults to the name of the distribution.}

\item{\code{xlab}}{Character string for the x-axis label. Defaults to "x".}

\item{\code{xlim}}{Numeric vector specifying the x-axis limits.}

\item{\code{xlim.t}}{Logical value specifyind to change the xlim default.}

\item{\code{ylab}}{Character string for the y-axis label. Defaults to "Density".}

\item{\code{line.col}}{Character string for the color of the plot line. Default is "red".}

\item{\code{fill.col}}{Character string for the color of the fill histogram plot line. Default is "lightblue".}

\item{\code{border.col}}{Character string for the color of the border of the fill histogram plot line. Default is "black".}

\item{\code{box}}{Logical value indicating whether to draw a box with the parameters in the plot. Default is TRUE.}

\item{\code{line.width}}{Numeric value specifying the width of the plot line. Default is 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Distr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
