% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_MSALinearity.R
\name{MSALinearity}
\alias{MSALinearity}
\title{MSALinearity-class: Class `MSALinearity`}
\description{
R6 class for performing Measurement System Analysis (MSA) Linearity studies.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{X}}{A data frame containing the independent variable(s) used in the linearity study.}

\item{\code{Y}}{A data frame containing the dependent variable(s) or responses measured in the linearity study.}

\item{\code{model}}{The linear model object resulting from the linearity analysis.}

\item{\code{conf.level}}{A numeric value specifying the confidence level for the linearity analysis. This should be between 0 and 1 (e.g., 0.95 for a 95\% confidence level).}

\item{\code{Linearity}}{A list or data frame containing the results of the linearity study, including the linearity value and associated statistics.}

\item{\code{GageName}}{A character string specifying the name of the gage or measurement system under analysis.}

\item{\code{GageTolerance}}{A numeric value specifying the tolerance of the gage or measurement system.}

\item{\code{DateOfStudy}}{A character string or Date object indicating the date when the linearity study was conducted.}

\item{\code{PersonResponsible}}{A character string specifying the name of the person responsible for the linearity study.}

\item{\code{Comments}}{A character string for additional comments or notes about the linearity study.}

\item{\code{facNames}}{A character vector specifying the names of the factors involved in the study, if any.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MSALinearity-response}{\code{MSALinearity$response()}}
\item \href{#method-MSALinearity-summary}{\code{MSALinearity$summary()}}
\item \href{#method-MSALinearity-plot}{\code{MSALinearity$plot()}}
\item \href{#method-MSALinearity-print}{\code{MSALinearity$print()}}
\item \href{#method-MSALinearity-as.data.frame}{\code{MSALinearity$as.data.frame()}}
\item \href{#method-MSALinearity-clone}{\code{MSALinearity$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-response"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-response}{}}}
\subsection{Method \code{response()}}{
Get and set the the \code{response} in an object of class \code{MSALinearity}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New response, If missing value get the \code{response}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-summary"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-summary}{}}}
\subsection{Method \code{summary()}}{
Methods for function \code{summary} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-plot"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-plot}{}}}
\subsection{Method \code{plot()}}{
Plots the measurement system, including individual biases, mean bias, and a regression line with confidence intervals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$plot(ylim, col, pch, lty = c(1, 2))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ylim}}{A numeric vector specifying the limits for the y-axis. If not provided, the limits are automatically calculated based on data.}

\item{\code{col}}{A vector specifying the colors to be used for different plot elements.}

\item{\code{pch}}{A numeric vector specifying the plotting characters (symbols) for individual data points and mean bias points.}

\item{\code{lty}}{A numeric vector specifying the line types for the regression line and its confidence intervals. The default is \code{c(1, 2)}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-print"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-print}{}}}
\subsection{Method \code{print()}}{
Methods for function \code{print} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Return a data frame with the information of the object \code{MSALinearity}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSALinearity-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MSALinearity-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSALinearity$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
