% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{optimum}
\alias{optimum}
\title{optimum: Optimal factor settings}
\usage{
optimum(fdo, constraints, steps = 25, type = "grid", start)
}
\arguments{
\item{fdo}{An object of class \code{\link{facDesign.c}} with \code{fits} and \code{desires} set.}

\item{constraints}{A list specifying the constraints for the factors, e.g., \code{list(A = c(-2,1), B = c(0, 0.8))}.}

\item{steps}{Number of grid points per factor if \code{type = `grid`}. Default is `25`.}

\item{type}{The type of search to perform. Supported values are \code{`grid`}, \code{`optim`}, and \code{`gosolnp`}. See Details for more information.}

\item{start}{A numeric vector providing the initial values for the factors when using \code{type = `optim`}.}
}
\value{
Return an object of class \code{\link{desOpt}}.
}
\description{
This function calculates the optimal factor settings based on defined desirabilities and constraints. It supports two approaches: (I) evaluating all possible factor settings via a grid search and (II) using optimization methods such as \code{`optim`} or \code{`gosolnp`} from the Rsolnp package. Using \code{`optim`} initial values for the factors to be optimized over can be set via start.
The optimality of the solution depends critically on the starting parameters which is why it is recommended to use \code{type=`gosolnp`} although calculation takes a while.
}
\details{
The function allows you to optimize the factor settings either by evaluating a grid of possible settings (\code{type = `grid`}) or by using optimization algorithms (\code{type = `optim` or `gosolnp`}). The choice of optimization method may significantly affect the result, especially for desirability functions that lack continuous first derivatives. When using \code{type = `optim`}, it is advisable to provide \code{start} values to avoid local optima. The \code{`gosolnp`} method is recommended for its robustness, although it may be computationally intensive.
}
\examples{
#Example 1: Simultaneous Optimization of Several Response Variables
#Define the response surface design as given in the paper and sort via Standard Order
fdo = rsmDesign(k = 3, alpha = 1.633, cc = 0, cs = 6)
fdo = randomize(fdo, so = TRUE)
#Attaching the 4 responses
y1 = c(102, 120, 117, 198, 103, 132,
        132, 139, 102, 154, 96, 163,
        116, 153, 133, 133, 140, 142,
        145, 142)

y2 = c(900, 860, 800, 2294, 490, 1289,
        1270, 1090, 770, 1690, 700, 1540,
        2184, 1784, 1300, 1300, 1145, 1090,
        1260, 1344)

y3 = c(470, 410, 570, 240, 640, 270,
        410, 380, 590, 260, 520, 380,
        520, 290, 380, 380, 430, 430,
        390, 390)

y4 = c(67.5, 65, 77.5, 74.5, 62.5, 67,
        78, 70, 76, 70, 63, 75,
        65, 71, 70, 68.5, 68, 68,
        69, 70)
fdo$.response(data.frame(y1, y2, y3, y4)[c(5,2,3,8,1,6,7,4,9:20),])
#Setting names and real values of the factors
fdo$names(c("silica", "silan", "sulfur"))
fdo$highs(c(1.7, 60, 2.8))
fdo$lows(c(0.7, 40, 1.8))
#Setting the desires
fdo$desires(desirability(y1, 120, 170, scale = c(1,1), target = "max"))
fdo$desires(desirability(y2, 1000, 1300, target = "max"))
fdo$desires(desirability(y3, 400, 600, target = 500))
fdo$desires(desirability(y4, 60, 75, target = 67.5))
#Setting the fits
fdo$set.fits(fdo$lm(y1 ~ A + B + C + A:B + A:C + B:C + I(A^2) + I(B^2) + I(C^2)))
fdo$set.fits(fdo$lm(y2 ~ A + B + C + A:B + A:C + B:C + I(A^2) + I(B^2) + I(C^2)))
fdo$set.fits(fdo$lm(y3 ~ A + B + C + A:B + A:C + B:C + I(A^2) + I(B^2) + I(C^2)))
fdo$set.fits(fdo$lm(y4 ~ A + B + C + A:B + A:C + B:C + I(A^2) + I(B^2) + I(C^2)))
#Calculate the best factor settings using type = "optim"
optimum(fdo, type = "optim")
#Calculate the best factor settings using type = "grid"
optimum(fdo, type = "grid")
}
\seealso{
\code{\link{overall}}, \code{\link{desirability}},
}
