% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{surveys}
\alias{surveys}
\title{Download State Survey Results}
\usage{
surveys(
  organization_id = NULL,
  survey_year = NULL,
  tidy = TRUE,
  .unnest = TRUE,
  ...
)
}
\arguments{
\item{organization_id}{(character) Filters the list to only those “belonging
to” one of the specified organizations. Multiple values may be specified.
required}

\item{survey_year}{(character) Filters the list to the year the survey was
performed. optional.}

\item{tidy}{(logical) \code{TRUE} (default) the function returns a tidied
tibble. \code{FALSE} the function returns the raw JSON string.}

\item{.unnest}{(logical) \code{TRUE} (default) the function attempts to unnest
data to longest format possible. This defaults to \code{TRUE} for backwards
compatibility but it is suggested to use \code{FALSE}.}

\item{...}{list of curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
If \code{tidy = FALSE} the raw JSON string is
returned, else the JSON data is parsed and returned as a list of tibbles.
}
\description{
Downloads data about state statistical (probability) survey results.
}
\details{
Arguments that allow multiple values should be entered as a comma
separated string with no spaces (\code{organization_id = "DOEE,21AWIC"}).
}
\note{
See \link{domain_values} to search values that can be queried.
}
\examples{

\dontrun{

## return surveys by organization
surveys(organization_id="SDDENR")

## return as a JSON string instead of a list of tibbles
surveys(organization_id="SDDENR", tidy = FALSE)
}
}
