% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Label.R
\name{initialize,Label-method}
\alias{initialize,Label-method}
\alias{label}
\alias{setBold}
\alias{setBold,Label,logical-method}
\alias{setText,Label,character-method}
\alias{setX}
\alias{setX,Label,numericOrCharacter-method}
\alias{setY}
\alias{setY,Label,numericOrCharacter-method}
\title{Initializes Label}
\usage{
\S4method{initialize}{Label}(.Object, text, bold, x, y, ...)

label(text, bold, x, y, ...)

setBold(.Object, bold)

\S4method{setBold}{Label,logical}(.Object, bold)

\S4method{setText}{Label,character}(.Object, text)

setX(.Object, x)

\S4method{setX}{Label,numericOrCharacter}(.Object, x)

setY(.Object, y)

\S4method{setY}{Label,numericOrCharacter}(.Object, y)
}
\arguments{
\item{.Object}{\linkS4class{Label}.}

\item{text}{\code{character}, text of a title.}

\item{bold}{\code{character}, specifies if label is bold or not.}

\item{x}{\code{numeric}, label's x position.}

\item{y}{\code{numeric}, label's y position.}

\item{...}{other properties of Label.}
}
\value{
(updated) .Object of class \linkS4class{Label}.
}
\description{
Uses the constructor to create the object
or update an existing one with the setters.
}
\examples{
# --- method initialize
new("Label", x = 10)

# --- constructor
label(text = "bonjour")
label(text = "Male", x = "28\%", y = "97\%")

# --- update property 'bold'
setBold(.Object = label(), bold = TRUE)

# --- update 'text'
setText(.Object = label(), text = "Bonjour")

# --- update 'x'
setX(.Object = label(), x = 16)

# --- update 'y'
setY(.Object = label(), y = 16)

}
