% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createbarerrorplots.R
\name{createbarerrorplots}
\alias{createbarerrorplots}
\title{createbarerrorplots helper function}
\usage{
createbarerrorplots(
  statstable_pre,
  statstable_post,
  rv,
  type,
  locus_id = NULL,
  plotdir,
  logfilename,
  mode = NULL,
  plot_height = 5,
  plot_width = 7.5,
  plot_textsize = 16
)
}
\arguments{
\item{statstable_pre}{A data.table object, containing the output of
\code{statisticsList_()} of the calculated regression parameters (form
the provided calibration data).}

\item{statstable_post}{A data.table object, containing the output of
\code{statisticsList_()} of the calculated regression parameters form
the corrected calibration data.}

\item{rv}{A list object. A list that contains additional objects needed
for the algorithms.}

\item{type}{A single integer. Type of data to be corrected: either \code{1L} (one
locus in many samples, e.g. pyrosequencing data) or \code{2L} (many loci in one
sample, e.g. next-generation sequencing data or microarray data).}

\item{locus_id}{A character string. Default: NULL. ID of the respective
locus (only used in type 2 correction).}

\item{plotdir}{A character string. Path to the folder,
where plots are saved.}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}

\item{mode}{A character string. Default: NULL. Used to indicate "corrected"
calibration data.}

\item{plot_height}{A integer value. The height (unit: inch) of the
resulting plots (default: 5).}

\item{plot_width}{A integer value. The width (unit: inch) of the
resulting plots (default: 7.5).}

\item{plot_textsize}{A integer value. The textsize of the
resulting plots (default: 16).}
}
\value{
This function creates error bar-plots to visualize the relative
error before and after bias correction and writes these plots to the
local filesystem.
}
\description{
Internal function to create relative-error bar plots.
}
\examples{
\donttest{
# define list object to save all data
rv <- list()
rv$minmax <- TRUE
rv$selection_method <- "RelError"
rv$sample_locus_name <- "Test"
rv$seed <- 1234

# define plotdir
rv$plotdir <- paste0(tempdir(), "/plots/")
dir.create(rv$plotdir)

# define logfilename
logfilename <- paste0(tempdir(), "/log.txt")

# import experimental file
exp_type_1 <- rBiasCorrection::example.data_experimental
rv$fileimport_experimental <- exp_type_1$dat

# import calibration file
cal_type_1 <- rBiasCorrection::example.data_calibration
rv$fileimport_calibration <- cal_type_1$dat
rv$vec_cal <- cal_type_1$vec_cal


# perform regression
regression_results <- regression_utility(
  rv$fileimport_calibration,
  "Testlocus",
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)

# extract regression results
rv$result_list <- regression_results$result_list

# get regression statistics
rv$reg_stats <- statistics_list(
  rv$result_list,
  minmax = TRUE
)

# select the better model based on the sum of squared errrors ("SSE")
rv$choices_list <- better_model(
  statstable_pre = rv$reg_stats,
  selection_method = "SSE"
)

# correct calibration data (to show corrected calibration curves)
solved_eq_h <- solving_equations(datatable = rv$fileimport_calibration,
                                 regmethod = rv$choices_list,
                                 type = 1,
                                 rv = rv,
                                 mode = "corrected",
                                 logfilename = logfilename,
                                 minmax = rv$minmax)
rv$fileimport_cal_corrected_h <- solved_eq_h$results
colnames(rv$fileimport_cal_corrected_h) <- colnames(
  rv$fileimport_calibration
)

# calculate new calibration curves from corrected calibration data
regression_results <- regression_utility(
  data = rv$fileimport_cal_corrected_h,
  samplelocusname = rv$sample_locus_name,
  rv = rv,
  mode = "corrected",
  logfilename = logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)
rv$result_list_hyperbolic <- regression_results$result_list


# save regression statistics to reactive value
rv$reg_stats_corrected_h <- statistics_list(
  resultlist = rv$result_list_hyperbolic,
  minmax = rv$minmax
)

createbarerrorplots(
  statstable_pre = rv$reg_stats,
  statstable_post = rv$reg_stats_corrected_h,
  rv = rv,
  type = 1,
  locus_id = NULL,
  plotdir = rv$plotdir,
  logfilename = logfilename,
  mode = "corrected_h",
  plot_height = 5,
  plot_width = 7.5,
  plot_textsize = 1
)
}

}
