% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-fdp.R
\name{fdp-class}
\alias{fdp-class}
\alias{fdp}
\title{fdp-class}
\description{
fdp-class

fdp-class
}
\details{
Container for class \code{fdp}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{yaml}}{a \code{list} containing the contents of the working
config.yaml}

\item{\code{fdp_config_dir}}{a \code{string} specifying the directory passed
from \verb{fair run}}

\item{\code{model_config}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the \code{storage_location} of the
working config.yaml}

\item{\code{submission_script}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the \code{storage_location} of the
submission script}

\item{\code{code_repo}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the GitHub repository}

\item{\code{code_run}}{a \code{string} specifying the URL of an entry in
the \code{code_run} table}

\item{\code{inputs}}{a \code{data.frame} containing metadata associated with
\code{code_run} inputs}

\item{\code{outputs}}{a \code{data.frame} containing metadata associated with
\code{code_run} outputs}

\item{\code{issues}}{a \code{data.frame} containing metadata associated with
\code{code_run} issues}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fdp-new}{\code{fdp$new()}}
\item \href{#method-fdp-print}{\code{fdp$print()}}
\item \href{#method-fdp-input}{\code{fdp$input()}}
\item \href{#method-fdp-output}{\code{fdp$output()}}
\item \href{#method-fdp-output_index}{\code{fdp$output_index()}}
\item \href{#method-fdp-raise_issue}{\code{fdp$raise_issue()}}
\item \href{#method-fdp-finalise_output_hash}{\code{fdp$finalise_output_hash()}}
\item \href{#method-fdp-finalise_output_url}{\code{fdp$finalise_output_url()}}
\item \href{#method-fdp-clone}{\code{fdp$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-new"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{fdp} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$new(
  yaml,
  fdp_config_dir,
  model_config,
  submission_script,
  code_repo,
  code_run
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yaml}}{a \code{list} containing the contents of the working
config.yaml}

\item{\code{fdp_config_dir}}{a \code{string} specifying the directory passed
from \verb{fair run}}

\item{\code{model_config}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the \code{storage_location} of the
working config.yaml}

\item{\code{submission_script}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the \code{storage_location} of the
submission script}

\item{\code{code_repo}}{a \code{string} specifying the URL of an entry in
the \code{object} table associated with the GitHub repository}

\item{\code{code_run}}{a \code{string} specifying the URL of an entry in
the \code{code_run} table}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a new \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-print"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-print}{}}}
\subsection{Method \code{print()}}{
Print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters, currently none are used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-input"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-input}{}}}
\subsection{Method \code{input()}}{
Record \code{code_run} inputs in \code{fdp} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$input(
  data_product,
  use_data_product,
  use_component,
  use_version,
  use_namespace,
  path,
  component_url
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_product}}{a \code{string} specifying the name of the data
product, used as a reference}

\item{\code{use_data_product}}{a \code{string} specifying the name of the data
product, used as input in the \code{code_run}}

\item{\code{use_component}}{a \code{string} specifying the name of the data
product component, used as input in the \code{code_run}}

\item{\code{use_version}}{a \code{string} specifying the data product version,
used as input in the \code{code_run}}

\item{\code{use_namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as input in the \code{code_run}}

\item{\code{path}}{a \code{string} specifying the location of the data product
in the local data store}

\item{\code{component_url}}{a \code{string} specifying the URL of an entry in the
\code{object_component} table}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an updated \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-output"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-output}{}}}
\subsection{Method \code{output()}}{
Record \code{code_run} outputs in \code{fdp} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$output(
  data_product,
  use_data_product,
  use_component,
  use_version,
  use_namespace,
  path,
  data_product_description,
  component_description,
  public
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_product}}{a \code{string} specifying the name of the data
product, used as a reference}

\item{\code{use_data_product}}{a \code{string} specifying the name of the data
product, used as output in the \code{code_run}}

\item{\code{use_component}}{a \code{string} specifying the name of the data
product component, used as output in the \code{code_run}}

\item{\code{use_version}}{a \code{string} specifying the version of the data
product, used as output in the \code{code_run}}

\item{\code{use_namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as output in the \code{code_run}}

\item{\code{path}}{a \code{string} specifying the location of the data product
in the local data store}

\item{\code{data_product_description}}{a \code{string} containing a description of
the data product}

\item{\code{component_description}}{a \code{string} containing a description of
the data product component}

\item{\code{public}}{}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an updated \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-output_index"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-output_index}{}}}
\subsection{Method \code{output_index()}}{
Return index of data product recorded in \code{fdp} object
so that an issue may be attached
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$output_index(data_product, component, version, namespace)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_product}}{a \code{string} specifying the name of the data
product, used as output in the \code{code_run}}

\item{\code{component}}{a \code{string} specifying the name of the data
product component, used as output in the \code{code_run}}

\item{\code{version}}{a \code{string} specifying the name of the data
product version, used as output in the \code{code_run}}

\item{\code{namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as input in the \code{code_run}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an index used to identify the data product
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-raise_issue"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-raise_issue}{}}}
\subsection{Method \code{raise_issue()}}{
Record \code{issue} in \code{fdp} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$raise_issue(
  index,
  type,
  use_data_product,
  use_component,
  use_version,
  use_namespace,
  issue,
  severity
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{a \code{numeric} index, used to identify each input and
output in the \code{fdp} object}

\item{\code{type}}{a \code{string} specifying the type of issue (one of
"data", "config", "script", "repo")}

\item{\code{use_data_product}}{a \code{string} specifying the name of the data
product, used as output in the \code{code_run}}

\item{\code{use_component}}{a \code{string} specifying the name of the data
product component, used as output in the \code{code_run}}

\item{\code{use_version}}{a \code{string} specifying the name of the data
product version, used as output in the \code{code_run}}

\item{\code{use_namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as input in the \code{code_run}}

\item{\code{issue}}{a \code{string} containing a free text description of the
\code{issue}}

\item{\code{severity}}{an \code{integer} specifying the severity of the
\code{issue}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an updated \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-finalise_output_hash"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-finalise_output_hash}{}}}
\subsection{Method \code{finalise_output_hash()}}{
Record file hash and update path name in \code{fdp} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$finalise_output_hash(
  use_data_product,
  use_data_product_runid,
  use_version,
  use_namespace,
  hash,
  new_path,
  data_product_url,
  delete_if_duplicate = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_data_product}}{a \code{string} specifying the name of the data
product, used as output in the \code{code_run}}

\item{\code{use_data_product_runid}}{a \code{string} specifying the name of the
data product, the same as \code{use_data_product} excluding the RUN_ID
variable}

\item{\code{use_version}}{a \code{string} specifying the name of the data
product version, used as output in the \code{code_run}}

\item{\code{use_namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as input in the \code{code_run}}

\item{\code{hash}}{a \code{string} specifying the hash of the file}

\item{\code{new_path}}{a \code{string} specifying the updated location (filename
is now the hash of the file) of the data product in the local data store}

\item{\code{data_product_url}}{a \code{string} specifying the URL of an
\code{object} associated with the \code{data_product}}

\item{\code{delete_if_duplicate}}{(optional) default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an updated \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-finalise_output_url"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-finalise_output_url}{}}}
\subsection{Method \code{finalise_output_url()}}{
Record \code{data_product} and component URLs in \code{fdp}
object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$finalise_output_url(
  use_data_product,
  use_component,
  use_version,
  use_namespace,
  component_url
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_data_product}}{a \code{string} specifying the name of the data
product, used as output in the \code{code_run}}

\item{\code{use_component}}{a \code{string} specifying the name of the data
product component, used as output in the \code{code_run}}

\item{\code{use_version}}{a \code{string} specifying the name of the data
product version, used as output in the \code{code_run}}

\item{\code{use_namespace}}{a \code{string} specifying the namespace in which
the data product resides, used as input in the \code{code_run}}

\item{\code{component_url}}{a \code{string} specifying the URL of an entry in the
\code{object_component} table}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an updated \code{fdp} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fdp-clone"></a>}}
\if{latex}{\out{\hypertarget{method-fdp-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fdp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
