% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.FSA.R
\name{predict.FSA}
\alias{predict.FSA}
\title{Prediction function for FSA solutions}
\usage{
\method{predict}{FSA}(object, ...)
}
\arguments{
\item{object}{FSA object to conduct predictions on.}

\item{...}{other parameters passed to fitmodels or predict functions. See help(fitmodels) or help(predict) for assistance.}
}
\value{
list of predicted values from each FSA model.
}
\description{
Prediction function for FSA solutions
}
\examples{
#use mtcars package see help(mtcars)
data(mtcars)
colnames(mtcars)
fit<-lmFSA(formula="mpg~hp*wt",data=mtcars,fixvar="hp",
             quad=FALSE,m=2,numrs=10,save_solutions=FALSE,cores=1)
predict(fit)
predict(fit,newdata=mtcars[1:15,])
}
