% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpi.R
\name{kpi_extract_ids}
\alias{kpi_extract_ids}
\title{Extract a vector of KPI ID strings from a Kolada KPI metadata table}
\usage{
kpi_extract_ids(kpi_df)
}
\arguments{
\item{kpi_df}{A Kolada KPI metadata table, e.g. as created by
\code{\link{get_kpi}}.}
}
\value{
A vector of KPI IDs.
}
\description{
This function is primarily intended as a convenient way to pass a (filtered)
Kolada KPI metadata table to \code{\link{get_values}}.
}
\examples{
if (kolada_available()) {
# Download Kolada data for the first KPI in the list matching the term "Grundskola" (primary school)
# for the years 2010-2019
# (omit the parameter "max_results" to actually download all data)
kpi_filter <- get_kpi(max_results = 500) \%>\%
  kpi_search("Grundskola")

# Only keep the top row
kpi_filter <- kpi_filter[1, ]

# Only download 100 observations
# (omit the parameter "max_results" to actually download all data)
kld_data <- get_values(
  kpi = kpi_extract_ids(kpi_filter),
  period = 2010:2019,
  max_results = 100
)
}

}
